<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

// This is by no means a complete list of all iso3166-2 level 1 subdivisions,
// but rather an unofficial list compiled by the Revive Adserver developers.

$RV_Geo_ISO3166_2_S1 = [
    'AD' => [
        'AD-07' => 'Andorra la Vella',
        'AD-02' => 'Canillo',
        'AD-03' => 'Encamp',
        'AD-08' => 'Escaldes-Engordany',
        'AD-04' => 'La Massana',
        'AD-05' => 'Ordino',
        'AD-06' => 'Sant Julià de Lòria',
    ],
    'AE' => [
        'AE-AZ' => 'Abū Z̧aby',
        'AE-FU' => 'Al Fujayrah',
        'AE-SH' => 'Ash Shāriqah',
        'AE-DU' => 'Dubayy',
        'AE-RK' => 'Ra’s al Khaymah',
        'AE-UQ' => 'Umm al Qaywayn',
        'AE-AJ' => '‘Ajmān',
    ],
    'AF' => [
        'AF-BDS' => 'Badakhshān',
        'AF-BGL' => 'Baghlān',
        'AF-BAL' => 'Balkh',
        'AF-BDG' => 'Bādghīs',
        'AF-BAM' => 'Bāmyān',
        'AF-DAY' => 'Dāykundī',
        'AF-FRA' => 'Farāh',
        'AF-FYB' => 'Fāryāb',
        'AF-GHA' => 'Ghaznī',
        'AF-GHO' => 'Ghōr',
        'AF-HEL' => 'Helmand',
        'AF-HER' => 'Herāt',
        'AF-JOW' => 'Jowzjān',
        'AF-KAN' => 'Kandahār',
        'AF-KHO' => 'Khōst',
        'AF-KNR' => 'Kunaṟ',
        'AF-KDZ' => 'Kunduz',
        'AF-KAB' => 'Kābul',
        'AF-KAP' => 'Kāpīsā',
        'AF-LAG' => 'Laghmān',
        'AF-LOG' => 'Lōgar',
        'AF-NAN' => 'Nangarhār',
        'AF-NIM' => 'Nīmrōz',
        'AF-NUR' => 'Nūristān',
        'AF-PIA' => 'Paktiyā',
        'AF-PKA' => 'Paktīkā',
        'AF-PAN' => 'Panjshayr',
        'AF-PAR' => 'Parwān',
        'AF-SAM' => 'Samangān',
        'AF-SAR' => 'Sar-e Pul',
        'AF-TAK' => 'Takhār',
        'AF-URU' => 'Uruzgān',
        'AF-WAR' => 'Wardak',
        'AF-ZAB' => 'Zābul',
    ],
    'AG' => [
        'AG-10' => 'Barbuda',
        'AG-11' => 'Redonda',
        'AG-03' => 'Saint George',
        'AG-04' => 'Saint John',
        'AG-05' => 'Saint Mary',
        'AG-06' => 'Saint Paul',
        'AG-07' => 'Saint Peter',
        'AG-08' => 'Saint Philip',
    ],
    'AL' => [
        'AL-01' => 'Berat',
        'AL-09' => 'Dibër',
        'AL-02' => 'Durrës',
        'AL-03' => 'Elbasan',
        'AL-04' => 'Fier',
        'AL-05' => 'Gjirokastër',
        'AL-06' => 'Korçë',
        'AL-07' => 'Kukës',
        'AL-08' => 'Lezhë',
        'AL-10' => 'Shkodër',
        'AL-11' => 'Tiranë',
        'AL-12' => 'Vlorë',
    ],
    'AM' => [
        'AM-AG' => 'Aragac̣otn',
        'AM-AR' => 'Ararat',
        'AM-AV' => 'Armavir',
        'AM-ER' => 'Erevan',
        'AM-GR' => 'Geġark\'unik\'',
        'AM-KT' => 'Kotayk\'',
        'AM-LO' => 'Loṙi',
        'AM-SU' => 'Syunik\'',
        'AM-TV' => 'Tavuš',
        'AM-VD' => 'Vayoć Jor',
        'AM-SH' => 'Širak',
    ],
    'AO' => [
        'AO-BGO' => 'Bengo',
        'AO-BGU' => 'Benguela',
        'AO-BIE' => 'Bié',
        'AO-CAB' => 'Cabinda',
        'AO-CNN' => 'Cunene',
        'AO-HUA' => 'Huambo',
        'AO-HUI' => 'Huíla',
        'AO-CCU' => 'Kuando Kubango',
        'AO-CNO' => 'Kwanza Norte',
        'AO-CUS' => 'Kwanza Sul',
        'AO-LUA' => 'Luanda',
        'AO-LNO' => 'Lunda Norte',
        'AO-LSU' => 'Lunda Sul',
        'AO-MAL' => 'Malange',
        'AO-MOX' => 'Moxico',
        'AO-NAM' => 'Namibe',
        'AO-UIG' => 'Uíge',
        'AO-ZAI' => 'Zaire',
    ],
    'AR' => [
        'AR-B' => 'Buenos Aires',
        'AR-K' => 'Catamarca',
        'AR-H' => 'Chaco',
        'AR-U' => 'Chubut',
        'AR-C' => 'Ciudad Autónoma de Buenos Aires',
        'AR-W' => 'Corrientes',
        'AR-X' => 'Córdoba',
        'AR-E' => 'Entre Ríos',
        'AR-P' => 'Formosa',
        'AR-Y' => 'Jujuy',
        'AR-L' => 'La Pampa',
        'AR-F' => 'La Rioja',
        'AR-M' => 'Mendoza',
        'AR-N' => 'Misiones',
        'AR-Q' => 'Neuquén',
        'AR-R' => 'Río Negro',
        'AR-A' => 'Salta',
        'AR-J' => 'San Juan',
        'AR-D' => 'San Luis',
        'AR-Z' => 'Santa Cruz',
        'AR-S' => 'Santa Fe',
        'AR-G' => 'Santiago del Estero',
        'AR-V' => 'Tierra del Fuego',
        'AR-T' => 'Tucumán',
    ],
    'AT' => [
        'AT-1' => 'Burgenland',
        'AT-2' => 'Kärnten',
        'AT-3' => 'Niederösterreich',
        'AT-4' => 'Oberösterreich',
        'AT-5' => 'Salzburg',
        'AT-6' => 'Steiermark',
        'AT-7' => 'Tirol',
        'AT-8' => 'Vorarlberg',
        'AT-9' => 'Wien',
    ],
    'AU' => [
        'AU-ACT' => 'Australian Capital Territory',
        'AU-NSW' => 'New South Wales',
        'AU-NT' => 'Northern Territory',
        'AU-QLD' => 'Queensland',
        'AU-SA' => 'South Australia',
        'AU-TAS' => 'Tasmania',
        'AU-VIC' => 'Victoria',
        'AU-WA' => 'Western Australia',
    ],
    'AZ' => [
        'AZ-ABS' => 'Abşeron',
        'AZ-AST' => 'Astara',
        'AZ-AGC' => 'Ağcabədi',
        'AZ-AGM' => 'Ağdam',
        'AZ-AGS' => 'Ağdaş',
        'AZ-AGA' => 'Ağstafa',
        'AZ-AGU' => 'Ağsu',
        'AZ-BA' => 'Bakı',
        'AZ-BAL' => 'Balakən',
        'AZ-BEY' => 'Beyləqan',
        'AZ-BIL' => 'Biləsuvar',
        'AZ-BAR' => 'Bərdə',
        'AZ-CAB' => 'Cəbrayıl',
        'AZ-CAL' => 'Cəlilabad',
        'AZ-DAS' => 'Daşkəsən',
        'AZ-FUZ' => 'Füzuli',
        'AZ-GOR' => 'Goranboy',
        'AZ-GYG' => 'Göygöl',
        'AZ-GOY' => 'Göyçay',
        'AZ-GAD' => 'Gədəbəy',
        'AZ-GA' => 'Gəncə',
        'AZ-HAC' => 'Hacıqabul',
        'AZ-KUR' => 'Kürdəmir',
        'AZ-KAL' => 'Kəlbəcər',
        'AZ-LAC' => 'Laçın',
        'AZ-LER' => 'Lerik',
        'AZ-LA' => 'Lənkəran',
        'AZ-LAN' => 'Lənkəran',
        'AZ-MAS' => 'Masallı',
        'AZ-MI' => 'Mingəçevir',
        'AZ-NA' => 'Naftalan',
        'AZ-NX' => 'Naxçıvan',
        'AZ-NEF' => 'Neftçala',
        'AZ-OGU' => 'Oğuz',
        'AZ-QAX' => 'Qax',
        'AZ-QAZ' => 'Qazax',
        'AZ-QOB' => 'Qobustan',
        'AZ-QBA' => 'Quba',
        'AZ-QBI' => 'Qubadlı',
        'AZ-QUS' => 'Qusar',
        'AZ-QAB' => 'Qəbələ',
        'AZ-SAT' => 'Saatlı',
        'AZ-SAB' => 'Sabirabad',
        'AZ-SAL' => 'Salyan',
        'AZ-SMX' => 'Samux',
        'AZ-SIY' => 'Siyəzən',
        'AZ-SM' => 'Sumqayıt',
        'AZ-TOV' => 'Tovuz',
        'AZ-TAR' => 'Tərtər',
        'AZ-UCA' => 'Ucar',
        'AZ-XA' => 'Xankəndi',
        'AZ-XAC' => 'Xaçmaz',
        'AZ-XCI' => 'Xocalı',
        'AZ-XVD' => 'Xocavənd',
        'AZ-XIZ' => 'Xızı',
        'AZ-YAR' => 'Yardımlı',
        'AZ-YE' => 'Yevlax',
        'AZ-YEV' => 'Yevlax',
        'AZ-ZAQ' => 'Zaqatala',
        'AZ-ZAN' => 'Zəngilan',
        'AZ-ZAR' => 'Zərdab',
        'AZ-IMI' => 'İmişli',
        'AZ-ISM' => 'İsmayıllı',
        'AZ-SBN' => 'Şabran',
        'AZ-SMI' => 'Şamaxı',
        'AZ-SR' => 'Şirvan',
        'AZ-SUS' => 'Şuşa',
        'AZ-SA' => 'Şəki',
        'AZ-SAK' => 'Şəki',
        'AZ-SKR' => 'Şəmkir',
    ],
    'BA' => [
        'BA-BRC' => 'Brčko distrikt',
        'BA-BIH' => 'Federacija Bosne i Hercegovine',
        'BA-SRP' => 'Republika Srpska',
    ],
    'BB' => [
        'BB-01' => 'Christ Church',
        'BB-02' => 'Saint Andrew',
        'BB-03' => 'Saint George',
        'BB-04' => 'Saint James',
        'BB-05' => 'Saint John',
        'BB-06' => 'Saint Joseph',
        'BB-07' => 'Saint Lucy',
        'BB-08' => 'Saint Michael',
        'BB-09' => 'Saint Peter',
        'BB-10' => 'Saint Philip',
        'BB-11' => 'Saint Thomas',
    ],
    'BD' => [
        'BD-A' => 'Barisal',
        'BD-B' => 'Chittagong',
        'BD-C' => 'Dhaka',
        'BD-D' => 'Khulna',
        'BD-H' => 'Mymensingh',
        'BD-E' => 'Rajshahi',
        'BD-F' => 'Rangpur',
        'BD-G' => 'Sylhet',
    ],
    'BE' => [
        'BE-BRU' => 'Bruxelles-Capitale, Région de',
        'BE-VLG' => 'Vlaams Gewest',
        'BE-WAL' => 'wallonne, Région',
    ],
    'BF' => [
        'BF-01' => 'Boucle du Mouhoun',
        'BF-02' => 'Cascades',
        'BF-03' => 'Centre',
        'BF-04' => 'Centre-Est',
        'BF-05' => 'Centre-Nord',
        'BF-06' => 'Centre-Ouest',
        'BF-07' => 'Centre-Sud',
        'BF-08' => 'Est',
        'BF-09' => 'Hauts-Bassins',
        'BF-10' => 'Nord',
        'BF-11' => 'Plateau-Central',
        'BF-12' => 'Sahel',
        'BF-13' => 'Sud-Ouest',
    ],
    'BG' => [
        'BG-01' => 'Blagoevgrad',
        'BG-02' => 'Burgas',
        'BG-08' => 'Dobrich',
        'BG-07' => 'Gabrovo',
        'BG-26' => 'Haskovo',
        'BG-09' => 'Kardzhali',
        'BG-10' => 'Kyustendil',
        'BG-11' => 'Lovech',
        'BG-12' => 'Montana',
        'BG-13' => 'Pazardzhik',
        'BG-14' => 'Pernik',
        'BG-15' => 'Pleven',
        'BG-16' => 'Plovdiv',
        'BG-17' => 'Razgrad',
        'BG-18' => 'Ruse',
        'BG-27' => 'Shumen',
        'BG-19' => 'Silistra',
        'BG-20' => 'Sliven',
        'BG-21' => 'Smolyan',
        'BG-23' => 'Sofia',
        'BG-22' => 'Sofia (stolitsa)',
        'BG-24' => 'Stara Zagora',
        'BG-25' => 'Targovishte',
        'BG-03' => 'Varna',
        'BG-04' => 'Veliko Tarnovo',
        'BG-05' => 'Vidin',
        'BG-06' => 'Vratsa',
        'BG-28' => 'Yambol',
    ],
    'BH' => [
        'BH-14' => 'Al Janūbīyah',
        'BH-15' => 'Al Muḩarraq',
        'BH-13' => 'Al ‘Āşimah',
        'BH-17' => 'Ash Shamālīyah',
    ],
    'BI' => [
        'BI-BB' => 'Bubanza',
        'BI-BM' => 'Bujumbura Mairie',
        'BI-BL' => 'Bujumbura Rural',
        'BI-BR' => 'Bururi',
        'BI-CA' => 'Cankuzo',
        'BI-CI' => 'Cibitoke',
        'BI-GI' => 'Gitega',
        'BI-KR' => 'Karuzi',
        'BI-KY' => 'Kayanza',
        'BI-KI' => 'Kirundo',
        'BI-MA' => 'Makamba',
        'BI-MU' => 'Muramvya',
        'BI-MY' => 'Muyinga',
        'BI-MW' => 'Mwaro',
        'BI-NG' => 'Ngozi',
        'BI-RM' => 'Rumonge',
        'BI-RT' => 'Rutana',
        'BI-RY' => 'Ruyigi',
    ],
    'BJ' => [
        'BJ-AL' => 'Alibori',
        'BJ-AK' => 'Atacora',
        'BJ-AQ' => 'Atlantique',
        'BJ-BO' => 'Borgou',
        'BJ-CO' => 'Collines',
        'BJ-KO' => 'Couffo',
        'BJ-DO' => 'Donga',
        'BJ-LI' => 'Littoral',
        'BJ-MO' => 'Mono',
        'BJ-OU' => 'Ouémé',
        'BJ-PL' => 'Plateau',
        'BJ-ZO' => 'Zou',
    ],
    'BN' => [
        'BN-BE' => 'Belait',
        'BN-BM' => 'Brunei-Muara',
        'BN-TE' => 'Temburong',
        'BN-TU' => 'Tutong',
    ],
    'BO' => [
        'BO-H' => 'Chuquisaca',
        'BO-C' => 'Cochabamba',
        'BO-B' => 'El Beni',
        'BO-L' => 'La Paz',
        'BO-O' => 'Oruro',
        'BO-N' => 'Pando',
        'BO-P' => 'Potosí',
        'BO-S' => 'Santa Cruz',
        'BO-T' => 'Tarija',
    ],
    'BQ' => [
        'BQ-BO' => 'Bonaire',
        'BQ-SA' => 'Saba',
        'BQ-SE' => 'Sint Eustatius',
    ],
    'BR' => [
        'BR-AC' => 'Acre',
        'BR-AL' => 'Alagoas',
        'BR-AP' => 'Amapá',
        'BR-AM' => 'Amazonas',
        'BR-BA' => 'Bahia',
        'BR-CE' => 'Ceará',
        'BR-DF' => 'Distrito Federal',
        'BR-ES' => 'Espírito Santo',
        'BR-GO' => 'Goiás',
        'BR-MA' => 'Maranhão',
        'BR-MT' => 'Mato Grosso',
        'BR-MS' => 'Mato Grosso do Sul',
        'BR-MG' => 'Minas Gerais',
        'BR-PR' => 'Paraná',
        'BR-PB' => 'Paraíba',
        'BR-PA' => 'Pará',
        'BR-PE' => 'Pernambuco',
        'BR-PI' => 'Piauí',
        'BR-RN' => 'Rio Grande do Norte',
        'BR-RS' => 'Rio Grande do Sul',
        'BR-RJ' => 'Rio de Janeiro',
        'BR-RO' => 'Rondônia',
        'BR-RR' => 'Roraima',
        'BR-SC' => 'Santa Catarina',
        'BR-SE' => 'Sergipe',
        'BR-SP' => 'São Paulo',
        'BR-TO' => 'Tocantins',
    ],
    'BS' => [
        'BS-AK' => 'Acklins',
        'BS-BY' => 'Berry Islands',
        'BS-BI' => 'Bimini',
        'BS-BP' => 'Black Point',
        'BS-CI' => 'Cat Island',
        'BS-CO' => 'Central Abaco',
        'BS-CS' => 'Central Andros',
        'BS-CE' => 'Central Eleuthera',
        'BS-FP' => 'City of Freeport',
        'BS-CK' => 'Crooked Island and Long Cay',
        'BS-EG' => 'East Grand Bahama',
        'BS-EX' => 'Exuma',
        'BS-GC' => 'Grand Cay',
        'BS-HI' => 'Harbour Island',
        'BS-HT' => 'Hope Town',
        'BS-IN' => 'Inagua',
        'BS-LI' => 'Long Island',
        'BS-MC' => 'Mangrove Cay',
        'BS-MG' => 'Mayaguana',
        'BS-MI' => 'Moore\'s Island',
        'BS-NO' => 'North Abaco',
        'BS-NS' => 'North Andros',
        'BS-NE' => 'North Eleuthera',
        'BS-RI' => 'Ragged Island',
        'BS-RC' => 'Rum Cay',
        'BS-SS' => 'San Salvador',
        'BS-SO' => 'South Abaco',
        'BS-SA' => 'South Andros',
        'BS-SE' => 'South Eleuthera',
        'BS-SW' => 'Spanish Wells',
        'BS-WG' => 'West Grand Bahama',
    ],
    'BT' => [
        'BT-33' => 'Bumthang',
        'BT-12' => 'Chhukha',
        'BT-22' => 'Dagana',
        'BT-GA' => 'Gasa',
        'BT-13' => 'Haa',
        'BT-44' => 'Lhuentse',
        'BT-42' => 'Monggar',
        'BT-11' => 'Paro',
        'BT-43' => 'Pemagatshel',
        'BT-23' => 'Punakha',
        'BT-45' => 'Samdrup Jongkhar',
        'BT-14' => 'Samtse',
        'BT-31' => 'Sarpang',
        'BT-15' => 'Thimphu',
        'BT-TY' => 'Trashi Yangtse',
        'BT-41' => 'Trashigang',
        'BT-32' => 'Trongsa',
        'BT-21' => 'Tsirang',
        'BT-24' => 'Wangdue Phodrang',
        'BT-34' => 'Zhemgang',
    ],
    'BW' => [
        'BW-CE' => 'Central',
        'BW-CH' => 'Chobe',
        'BW-FR' => 'Francistown',
        'BW-GA' => 'Gaborone',
        'BW-GH' => 'Ghanzi',
        'BW-JW' => 'Jwaneng',
        'BW-KG' => 'Kgalagadi',
        'BW-KL' => 'Kgatleng',
        'BW-KW' => 'Kweneng',
        'BW-LO' => 'Lobatse',
        'BW-NE' => 'North East',
        'BW-NW' => 'North West',
        'BW-SP' => 'Selibe Phikwe',
        'BW-SE' => 'South East',
        'BW-SO' => 'Southern',
        'BW-ST' => 'Sowa Town',
    ],
    'BY' => [
        'BY-BR' => 'Brestskaya voblasts\'',
        'BY-HO' => 'Homyel\'skaya voblasts\'',
        'BY-HM' => 'Horad Minsk',
        'BY-HR' => 'Hrodzienskaja voblasć',
        'BY-MA' => 'Mahilyowskaya voblasts\'',
        'BY-MI' => 'Minskaya voblasts\'',
        'BY-VI' => 'Vitsyebskaya voblasts\'',
    ],
    'BZ' => [
        'BZ-BZ' => 'Belize',
        'BZ-CY' => 'Cayo',
        'BZ-CZL' => 'Corozal',
        'BZ-OW' => 'Orange Walk',
        'BZ-SC' => 'Stann Creek',
        'BZ-TOL' => 'Toledo',
    ],
    'CA' => [
        'CA-AB' => 'Alberta',
        'CA-BC' => 'British Columbia',
        'CA-MB' => 'Manitoba',
        'CA-NB' => 'New Brunswick',
        'CA-NL' => 'Newfoundland and Labrador',
        'CA-NT' => 'Northwest Territories',
        'CA-NS' => 'Nova Scotia',
        'CA-NU' => 'Nunavut',
        'CA-ON' => 'Ontario',
        'CA-PE' => 'Prince Edward Island',
        'CA-QC' => 'Quebec',
        'CA-SK' => 'Saskatchewan',
        'CA-YT' => 'Yukon',
    ],
    'CD' => [
        'CD-BU' => 'Bas-Uélé',
        'CD-HK' => 'Haut-Katanga',
        'CD-HL' => 'Haut-Lomami',
        'CD-HU' => 'Haut-Uélé',
        'CD-IT' => 'Ituri',
        'CD-KS' => 'Kasaï',
        'CD-KC' => 'Kasaï Central',
        'CD-KE' => 'Kasaï Oriental',
        'CD-KN' => 'Kinshasa',
        'CD-BC' => 'Kongo Central',
        'CD-KG' => 'Kwango',
        'CD-KL' => 'Kwilu',
        'CD-LO' => 'Lomami',
        'CD-LU' => 'Lualaba',
        'CD-MN' => 'Mai-Ndombe',
        'CD-MA' => 'Maniema',
        'CD-MO' => 'Mongala',
        'CD-NK' => 'Nord-Kivu',
        'CD-NU' => 'Nord-Ubangi',
        'CD-SA' => 'Sankuru',
        'CD-SK' => 'Sud-Kivu',
        'CD-SU' => 'Sud-Ubangi',
        'CD-TA' => 'Tanganyika',
        'CD-TO' => 'Tshopo',
        'CD-TU' => 'Tshuapa',
        'CD-EQ' => 'Équateur',
    ],
    'CF' => [
        'CF-BB' => 'Bamingui-Bangoran',
        'CF-BGF' => 'Bangui',
        'CF-BK' => 'Basse-Kotto',
        'CF-KB' => 'Gribingui',
        'CF-HM' => 'Haut-Mbomou',
        'CF-HK' => 'Haute-Kotto',
        'CF-HS' => 'Haute-Sangha / Mambéré-Kadéï',
        'CF-KG' => 'Kémo-Gribingui',
        'CF-LB' => 'Lobaye',
        'CF-MB' => 'Mbomou',
        'CF-NM' => 'Nana-Mambéré',
        'CF-MP' => 'Ombella-Mpoko',
        'CF-UK' => 'Ouaka',
        'CF-AC' => 'Ouham',
        'CF-OP' => 'Ouham-Pendé',
        'CF-SE' => 'Sangha',
        'CF-VK' => 'Vakaga',
    ],
    'CG' => [
        'CG-11' => 'Bouenza',
        'CG-BZV' => 'Brazzaville',
        'CG-8' => 'Cuvette',
        'CG-15' => 'Cuvette-Ouest',
        'CG-5' => 'Kouilou',
        'CG-7' => 'Likouala',
        'CG-2' => 'Lékoumou',
        'CG-9' => 'Niari',
        'CG-14' => 'Plateaux',
        'CG-16' => 'Pointe-Noire',
        'CG-12' => 'Pool',
        'CG-13' => 'Sangha',
    ],
    'CH' => [
        'CH-AG' => 'Aargau',
        'CH-AR' => 'Appenzell Ausserrhoden',
        'CH-AI' => 'Appenzell Innerrhoden',
        'CH-BL' => 'Basel-Landschaft',
        'CH-BS' => 'Basel-Stadt',
        'CH-BE' => 'Bern',
        'CH-FR' => 'Freiburg',
        'CH-GL' => 'Glarus',
        'CH-GR' => 'Graubünden',
        'CH-LU' => 'Luzern',
        'CH-NW' => 'Nidwalden',
        'CH-OW' => 'Obwalden',
        'CH-SG' => 'Sankt Gallen',
        'CH-SH' => 'Schaffhausen',
        'CH-SZ' => 'Schwyz',
        'CH-SO' => 'Solothurn',
        'CH-TG' => 'Thurgau',
        'CH-UR' => 'Uri',
        'CH-VS' => 'Wallis',
        'CH-ZG' => 'Zug',
        'CH-ZH' => 'Zürich',
        'CH-GE' => 'Genève',
        'CH-JU' => 'Jura',
        'CH-NE' => 'Neuchâtel',
        'CH-TI' => 'Ticino',
        'CH-VD' => 'Vaud',
    ],
    'CI' => [
        'CI-AB' => 'Abidjan',
        'CI-BS' => 'Bas-Sassandra',
        'CI-CM' => 'Comoé',
        'CI-DN' => 'Denguélé',
        'CI-GD' => 'Gôh-Djiboua',
        'CI-LC' => 'Lacs',
        'CI-LG' => 'Lagunes',
        'CI-MG' => 'Montagnes',
        'CI-SM' => 'Sassandra-Marahoué',
        'CI-SV' => 'Savanes',
        'CI-VB' => 'Vallée du Bandama',
        'CI-WR' => 'Woroba',
        'CI-YM' => 'Yamoussoukro',
        'CI-ZZ' => 'Zanzan',
    ],
    'CL' => [
        'CL-AI' => 'Aisén del General Carlos Ibañez del Campo',
        'CL-AN' => 'Antofagasta',
        'CL-AP' => 'Arica y Parinacota',
        'CL-AT' => 'Atacama',
        'CL-BI' => 'Biobío',
        'CL-CO' => 'Coquimbo',
        'CL-AR' => 'La Araucanía',
        'CL-LI' => 'Libertador General Bernardo O\'Higgins',
        'CL-LL' => 'Los Lagos',
        'CL-LR' => 'Los Ríos',
        'CL-MA' => 'Magallanes',
        'CL-ML' => 'Maule',
        'CL-RM' => 'Región Metropolitana de Santiago',
        'CL-TA' => 'Tarapacá',
        'CL-VS' => 'Valparaíso',
    ],
    'CM' => [
        'CM-AD' => 'Adamaoua',
        'CM-CE' => 'Centre',
        'CM-ES' => 'East',
        'CM-EN' => 'Far North',
        'CM-LT' => 'Littoral',
        'CM-NO' => 'North',
        'CM-NW' => 'North-West',
        'CM-SU' => 'South',
        'CM-SW' => 'South-West',
        'CM-OU' => 'West',
    ],
    'CN' => [
        'CN-AH' => 'Anhui Sheng',
        'CN-MO' => 'Aomen Tebiexingzhengqu (see also separate country code entry under MO)',
        'CN-BJ' => 'Beijing Shi',
        'CN-CQ' => 'Chongqing Shi',
        'CN-FJ' => 'Fujian Sheng',
        'CN-GS' => 'Gansu Sheng',
        'CN-GD' => 'Guangdong Sheng',
        'CN-GX' => 'Guangxi Zhuangzu Zizhiqu',
        'CN-GZ' => 'Guizhou Sheng',
        'CN-HI' => 'Hainan Sheng',
        'CN-HE' => 'Hebei Sheng',
        'CN-HL' => 'Heilongjiang Sheng',
        'CN-HA' => 'Henan Sheng',
        'CN-HB' => 'Hubei Sheng',
        'CN-HN' => 'Hunan Sheng',
        'CN-JS' => 'Jiangsu Sheng',
        'CN-JX' => 'Jiangxi Sheng',
        'CN-JL' => 'Jilin Sheng',
        'CN-LN' => 'Liaoning Sheng',
        'CN-NX' => 'Ningxia Huizi Zizhiqu',
        'CN-QH' => 'Qinghai Sheng',
        'CN-SN' => 'Shaanxi Sheng',
        'CN-SD' => 'Shandong Sheng',
        'CN-SH' => 'Shanghai Shi',
        'CN-SX' => 'Shanxi Sheng',
        'CN-SC' => 'Sichuan Sheng',
        'CN-TW' => 'Taiwan Sheng (see also separate country code entry under TW)',
        'CN-TJ' => 'Tianjin Shi',
        'CN-HK' => 'Xianggang Tebiexingzhengqu (see also separate country code entry under HK)',
        'CN-XJ' => 'Xinjiang Uygur Zizhiqu',
        'CN-XZ' => 'Xizang Zizhiqu',
        'CN-YN' => 'Yunnan Sheng',
        'CN-ZJ' => 'Zhejiang Sheng',
        'CN-NM' => 'Nei Mongol Zizhiqu',
    ],
    'CO' => [
        'CO-AMA' => 'Amazonas',
        'CO-ANT' => 'Antioquia',
        'CO-ARA' => 'Arauca',
        'CO-ATL' => 'Atlántico',
        'CO-BOL' => 'Bolívar',
        'CO-BOY' => 'Boyacá',
        'CO-CAL' => 'Caldas',
        'CO-CAQ' => 'Caquetá',
        'CO-CAS' => 'Casanare',
        'CO-CAU' => 'Cauca',
        'CO-CES' => 'Cesar',
        'CO-CHO' => 'Chocó',
        'CO-CUN' => 'Cundinamarca',
        'CO-COR' => 'Córdoba',
        'CO-DC' => 'Distrito Capital de Bogotá',
        'CO-GUA' => 'Guainía',
        'CO-GUV' => 'Guaviare',
        'CO-HUI' => 'Huila',
        'CO-LAG' => 'La Guajira',
        'CO-MAG' => 'Magdalena',
        'CO-MET' => 'Meta',
        'CO-NAR' => 'Nariño',
        'CO-NSA' => 'Norte de Santander',
        'CO-PUT' => 'Putumayo',
        'CO-QUI' => 'Quindío',
        'CO-RIS' => 'Risaralda',
        'CO-SAP' => 'San Andrés, Providencia y Santa Catalina',
        'CO-SAN' => 'Santander',
        'CO-SUC' => 'Sucre',
        'CO-TOL' => 'Tolima',
        'CO-VAC' => 'Valle del Cauca',
        'CO-VAU' => 'Vaupés',
        'CO-VID' => 'Vichada',
    ],
    'CR' => [
        'CR-A' => 'Alajuela',
        'CR-C' => 'Cartago',
        'CR-G' => 'Guanacaste',
        'CR-H' => 'Heredia',
        'CR-L' => 'Limón',
        'CR-P' => 'Puntarenas',
        'CR-SJ' => 'San José',
    ],
    'CU' => [
        'CU-15' => 'Artemisa',
        'CU-09' => 'Camagüey',
        'CU-08' => 'Ciego de Ávila',
        'CU-06' => 'Cienfuegos',
        'CU-12' => 'Granma',
        'CU-14' => 'Guantánamo',
        'CU-11' => 'Holguín',
        'CU-99' => 'Isla de la Juventud',
        'CU-03' => 'La Habana',
        'CU-10' => 'Las Tunas',
        'CU-04' => 'Matanzas',
        'CU-16' => 'Mayabeque',
        'CU-01' => 'Pinar del Río',
        'CU-07' => 'Sancti Spíritus',
        'CU-13' => 'Santiago de Cuba',
        'CU-05' => 'Villa Clara',
    ],
    'CV' => [
        'CV-B' => 'Ilhas de Barlavento',
        'CV-S' => 'Ilhas de Sotavento',
    ],
    'CY' => [
        'CY-04' => 'Ammochostos',
        'CY-06' => 'Keryneia',
        'CY-03' => 'Larnaka',
        'CY-01' => 'Lefkosia',
        'CY-02' => 'Lemesos',
        'CY-05' => 'Pafos',
    ],
    'CZ' => [
        'CZ-64' => 'Jihomoravský kraj',
        'CZ-31' => 'Jihočeský kraj',
        'CZ-41' => 'Karlovarský kraj',
        'CZ-63' => 'Kraj Vysočina',
        'CZ-52' => 'Královéhradecký kraj',
        'CZ-51' => 'Liberecký kraj',
        'CZ-80' => 'Moravskoslezský kraj',
        'CZ-71' => 'Olomoucký kraj',
        'CZ-53' => 'Pardubický kraj',
        'CZ-32' => 'Plzeňský kraj',
        'CZ-10' => 'Praha, Hlavní mešto',
        'CZ-20' => 'Středočeský kraj',
        'CZ-72' => 'Zlínský kraj',
        'CZ-42' => 'Ústecký kraj',
    ],
    'DE' => [
        'DE-BW' => 'Baden-Württemberg',
        'DE-BY' => 'Bayern',
        'DE-BE' => 'Berlin',
        'DE-BB' => 'Brandenburg',
        'DE-HB' => 'Bremen',
        'DE-HH' => 'Hamburg',
        'DE-HE' => 'Hessen',
        'DE-MV' => 'Mecklenburg-Vorpommern',
        'DE-NI' => 'Niedersachsen',
        'DE-NW' => 'Nordrhein-Westfalen',
        'DE-RP' => 'Rheinland-Pfalz',
        'DE-SL' => 'Saarland',
        'DE-SN' => 'Sachsen',
        'DE-ST' => 'Sachsen-Anhalt',
        'DE-SH' => 'Schleswig-Holstein',
        'DE-TH' => 'Thüringen',
    ],
    'DJ' => [
        'DJ-OB' => 'Awbūk',
        'DJ-DI' => 'Dikhīl',
        'DJ-DJ' => 'Jībūtī',
        'DJ-TA' => 'Tājūrah',
        'DJ-AS' => '‘Alī Şabīḩ',
        'DJ-AR' => '‘Artā',
    ],
    'DK' => [
        'DK-84' => 'Hovedstaden',
        'DK-82' => 'Midtjylland',
        'DK-81' => 'Nordjylland',
        'DK-85' => 'Sjælland',
        'DK-83' => 'Syddanmark',
    ],
    'DM' => [
        'DM-02' => 'Saint Andrew',
        'DM-03' => 'Saint David',
        'DM-04' => 'Saint George',
        'DM-05' => 'Saint John',
        'DM-06' => 'Saint Joseph',
        'DM-07' => 'Saint Luke',
        'DM-08' => 'Saint Mark',
        'DM-09' => 'Saint Patrick',
        'DM-10' => 'Saint Paul',
        'DM-11' => 'Saint Peter',
    ],
    'DO' => [
        'DO-33' => 'Cibao Nordeste',
        'DO-34' => 'Cibao Noroeste',
        'DO-35' => 'Cibao Norte',
        'DO-36' => 'Cibao Sur',
        'DO-37' => 'El Valle',
        'DO-38' => 'Enriquillo',
        'DO-39' => 'Higuamo',
        'DO-40' => 'Ozama',
        'DO-41' => 'Valdesia',
        'DO-42' => 'Yuma',
    ],
    'DZ' => [
        'DZ-01' => 'Adrar',
        'DZ-16' => 'Alger',
        'DZ-23' => 'Annaba',
        'DZ-44' => 'Aïn Defla',
        'DZ-46' => 'Aïn Témouchent',
        'DZ-05' => 'Batna',
        'DZ-07' => 'Biskra',
        'DZ-09' => 'Blida',
        'DZ-34' => 'Bordj Bou Arréridj',
        'DZ-10' => 'Bouira',
        'DZ-35' => 'Boumerdès',
        'DZ-08' => 'Béchar',
        'DZ-06' => 'Béjaïa',
        'DZ-02' => 'Chlef',
        'DZ-25' => 'Constantine',
        'DZ-17' => 'Djelfa',
        'DZ-32' => 'El Bayadh',
        'DZ-39' => 'El Oued',
        'DZ-36' => 'El Tarf',
        'DZ-47' => 'Ghardaïa',
        'DZ-24' => 'Guelma',
        'DZ-33' => 'Illizi',
        'DZ-18' => 'Jijel',
        'DZ-40' => 'Khenchela',
        'DZ-03' => 'Laghouat',
        'DZ-28' => 'M\'sila',
        'DZ-29' => 'Mascara',
        'DZ-43' => 'Mila',
        'DZ-27' => 'Mostaganem',
        'DZ-26' => 'Médéa',
        'DZ-45' => 'Naama',
        'DZ-31' => 'Oran',
        'DZ-30' => 'Ouargla',
        'DZ-04' => 'Oum el Bouaghi',
        'DZ-48' => 'Relizane',
        'DZ-20' => 'Saïda',
        'DZ-22' => 'Sidi Bel Abbès',
        'DZ-21' => 'Skikda',
        'DZ-41' => 'Souk Ahras',
        'DZ-19' => 'Sétif',
        'DZ-11' => 'Tamanrasset',
        'DZ-14' => 'Tiaret',
        'DZ-37' => 'Tindouf',
        'DZ-42' => 'Tipaza',
        'DZ-38' => 'Tissemsilt',
        'DZ-15' => 'Tizi Ouzou',
        'DZ-13' => 'Tlemcen',
        'DZ-12' => 'Tébessa',
    ],
    'EC' => [
        'EC-A' => 'Azuay',
        'EC-B' => 'Bolívar',
        'EC-C' => 'Carchi',
        'EC-F' => 'Cañar',
        'EC-H' => 'Chimborazo',
        'EC-X' => 'Cotopaxi',
        'EC-O' => 'El Oro',
        'EC-E' => 'Esmeraldas',
        'EC-W' => 'Galápagos',
        'EC-G' => 'Guayas',
        'EC-I' => 'Imbabura',
        'EC-L' => 'Loja',
        'EC-R' => 'Los Ríos',
        'EC-M' => 'Manabí',
        'EC-S' => 'Morona Santiago',
        'EC-N' => 'Napo',
        'EC-D' => 'Orellana',
        'EC-Y' => 'Pastaza',
        'EC-P' => 'Pichincha',
        'EC-SE' => 'Santa Elena',
        'EC-SD' => 'Santo Domingo de los Tsáchilas',
        'EC-U' => 'Sucumbíos',
        'EC-T' => 'Tungurahua',
        'EC-Z' => 'Zamora Chinchipe',
    ],
    'EE' => [
        'EE-37' => 'Harjumaa',
        'EE-39' => 'Hiiumaa',
        'EE-44' => 'Ida-Virumaa',
        'EE-51' => 'Järvamaa',
        'EE-49' => 'Jõgevamaa',
        'EE-59' => 'Lääne-Virumaa',
        'EE-57' => 'Läänemaa',
        'EE-67' => 'Pärnumaa',
        'EE-65' => 'Põlvamaa',
        'EE-70' => 'Raplamaa',
        'EE-74' => 'Saaremaa',
        'EE-78' => 'Tartumaa',
        'EE-82' => 'Valgamaa',
        'EE-84' => 'Viljandimaa',
        'EE-86' => 'Võrumaa',
    ],
    'EG' => [
        'EG-DK' => 'Ad Daqahlīyah',
        'EG-BA' => 'Al Baḩr al Aḩmar',
        'EG-BH' => 'Al Buḩayrah',
        'EG-FYM' => 'Al Fayyūm',
        'EG-GH' => 'Al Gharbīyah',
        'EG-ALX' => 'Al Iskandarīyah',
        'EG-IS' => 'Al Ismā\'īlīyah',
        'EG-GZ' => 'Al Jīzah',
        'EG-MN' => 'Al Minyā',
        'EG-MNF' => 'Al Minūfīyah',
        'EG-KB' => 'Al Qalyūbīyah',
        'EG-C' => 'Al Qāhirah',
        'EG-LX' => 'Al Uqşur',
        'EG-WAD' => 'Al Wādī al Jadīd',
        'EG-SUZ' => 'As Suways',
        'EG-SHR' => 'Ash Sharqīyah',
        'EG-ASN' => 'Aswān',
        'EG-AST' => 'Asyūţ',
        'EG-BNS' => 'Banī Suwayf',
        'EG-PTS' => 'Būr Sa‘īd',
        'EG-DT' => 'Dumyāţ',
        'EG-JS' => 'Janūb Sīnā\'',
        'EG-KFS' => 'Kafr ash Shaykh',
        'EG-MT' => 'Maţrūḩ',
        'EG-KN' => 'Qinā',
        'EG-SIN' => 'Shamāl Sīnā\'',
        'EG-SHG' => 'Sūhāj',
    ],
    'ER' => [
        'ER-MA' => 'Ma’ĭkel',
        'ER-DU' => 'Debub',
        'ER-AN' => '‘Anseba',
        'ER-DK' => 'Debubawi K’eyyĭḥ Baḥri',
        'ER-GB' => 'Gash-Barka',
        'ER-SK' => 'Semienawi K’eyyĭḥ Baḥri',
    ],
    'ES' => [
        'ES-AN' => 'Andalucía',
        'ES-AR' => 'Aragón',
        'ES-AS' => 'Asturias, Principado de',
        'ES-CN' => 'Canarias',
        'ES-CB' => 'Cantabria',
        'ES-CL' => 'Castilla y León',
        'ES-CM' => 'Castilla-La Mancha',
        'ES-CE' => 'Ceuta',
        'ES-EX' => 'Extremadura',
        'ES-RI' => 'La Rioja',
        'ES-MD' => 'Madrid, Comunidad de',
        'ES-ML' => 'Melilla',
        'ES-MC' => 'Murcia, Región de',
        'ES-NC' => 'Navarra, Comunidad Foral de',
        'ES-PV' => 'País Vasco',
        'ES-VC' => 'Valenciana, Comunidad',
        'ES-CT' => 'Catalunya [Cataluña]',
        'ES-GA' => 'Galicia [Galicia]',
        'ES-IB' => 'Illes Balears [Islas Baleares]',
    ],
    'ET' => [
        'ET-BE' => 'Bīnshangul Gumuz',
        'ET-DD' => 'Dirē Dawa',
        'ET-GA' => 'Gambēla Hizboch',
        'ET-HA' => 'Hārerī Hizb',
        'ET-OR' => 'Oromīya',
        'ET-SO' => 'Sumalē',
        'ET-TI' => 'Tigray',
        'ET-SN' => 'YeDebub Bihēroch Bihēreseboch na Hizboch',
        'ET-AA' => 'Ādīs Ābeba',
        'ET-AF' => 'Āfar',
        'ET-AM' => 'Āmara',
    ],
    'FI' => [
        'FI-01' => 'Ahvenanmaan maakunta',
        'FI-02' => 'Etelä-Karjala',
        'FI-03' => 'Etelä-Pohjanmaa',
        'FI-04' => 'Etelä-Savo',
        'FI-05' => 'Kainuu',
        'FI-06' => 'Kanta-Häme',
        'FI-07' => 'Keski-Pohjanmaa',
        'FI-08' => 'Keski-Suomi',
        'FI-09' => 'Kymenlaakso',
        'FI-10' => 'Lappi',
        'FI-11' => 'Pirkanmaa',
        'FI-12' => 'Pohjanmaa',
        'FI-13' => 'Pohjois-Karjala',
        'FI-14' => 'Pohjois-Pohjanmaa',
        'FI-15' => 'Pohjois-Savo',
        'FI-16' => 'Päijät-Häme',
        'FI-17' => 'Satakunta',
        'FI-18' => 'Uusimaa',
        'FI-19' => 'Varsinais-Suomi',
    ],
    'FJ' => [
        'FJ-C' => 'Central',
        'FJ-E' => 'Eastern',
        'FJ-N' => 'Northern',
        'FJ-R' => 'Rotuma',
        'FJ-W' => 'Western',
    ],
    'FM' => [
        'FM-TRK' => 'Chuuk',
        'FM-KSA' => 'Kosrae',
        'FM-PNI' => 'Pohnpei',
        'FM-YAP' => 'Yap',
    ],
    'FR' => [
        'FR-ARA' => 'Auvergne-Rhône-Alpes',
        'FR-BFC' => 'Bourgogne-Franche-Comté',
        'FR-BRE' => 'Bretagne',
        'FR-CVL' => 'Centre-Val de Loire',
        'FR-CP' => 'Clipperton',
        'FR-COR' => 'Corse',
        'FR-GES' => 'Grand-Est',
        'FR-GUA' => 'Guadeloupe',
        'FR-GF' => 'Guyane (française) (see also separate country code entry under GF)',
        'FR-HDF' => 'Hauts-de-France',
        'FR-LRE' => 'La Réunion',
        'FR-MQ' => 'Martinique (see also separate country code entry under MQ)',
        'FR-MAY' => 'Mayotte',
        'FR-NOR' => 'Normandie',
        'FR-NAQ' => 'Nouvelle-Aquitaine',
        'FR-NC' => 'Nouvelle-Calédonie (see also separate country code entry under NC)',
        'FR-OCC' => 'Occitanie',
        'FR-PDL' => 'Pays-de-la-Loire',
        'FR-PF' => 'Polynésie française (see also separate country code entry under PF)',
        'FR-PAC' => 'Provence-Alpes-Côte-d’Azur',
        'FR-BL' => 'Saint-Barthélemy (see also separate country code entry under BL)',
        'FR-MF' => 'Saint-Martin (see also separate country code entry under MF)',
        'FR-PM' => 'Saint-Pierre-et-Miquelon (see also separate country code entry under PM)',
        'FR-TF' => 'Terres australes françaises (see also separate country code entry under TF)',
        'FR-WF' => 'Wallis-et-Futuna (see also separate country code entry under WF)',
        'FR-IDF' => 'Île-de-France',
    ],
    'GA' => [
        'GA-1' => 'Estuaire',
        'GA-2' => 'Haut-Ogooué',
        'GA-3' => 'Moyen-Ogooué',
        'GA-4' => 'Ngounié',
        'GA-5' => 'Nyanga',
        'GA-6' => 'Ogooué-Ivindo',
        'GA-7' => 'Ogooué-Lolo',
        'GA-8' => 'Ogooué-Maritime',
        'GA-9' => 'Woleu-Ntem',
    ],
    'GB' => [
        'GB-ENG' => 'England',
        'GB-EAW' => 'England and Wales',
        'GB-GBN' => 'Great Britain',
        'GB-NIR' => 'Northern Ireland',
        'GB-SCT' => 'Scotland',
        'GB-UKM' => 'United Kingdom',
        'GB-WLS' => 'Wales [Cymru GB-CYM]',
    ],
    'GD' => [
        'GD-01' => 'Saint Andrew',
        'GD-02' => 'Saint David',
        'GD-03' => 'Saint George',
        'GD-04' => 'Saint John',
        'GD-05' => 'Saint Mark',
        'GD-06' => 'Saint Patrick',
        'GD-10' => 'Southern Grenadine Islands',
    ],
    'GE' => [
        'GE-AB' => 'Abkhazia',
        'GE-AJ' => 'Ajaria',
        'GE-GU' => 'Guria',
        'GE-IM' => 'Imereti',
        'GE-KA' => 'K\'akheti',
        'GE-KK' => 'Kvemo Kartli',
        'GE-MM' => 'Mtskheta-Mtianeti',
        'GE-RL' => 'Rach\'a-Lechkhumi-Kvemo Svaneti',
        'GE-SZ' => 'Samegrelo-Zemo Svaneti',
        'GE-SJ' => 'Samtskhe-Javakheti',
        'GE-SK' => 'Shida Kartli',
        'GE-TB' => 'Tbilisi',
    ],
    'GH' => [
        'GH-AH' => 'Ashanti',
        'GH-BA' => 'Brong-Ahafo',
        'GH-CP' => 'Central',
        'GH-EP' => 'Eastern',
        'GH-AA' => 'Greater Accra',
        'GH-NP' => 'Northern',
        'GH-UE' => 'Upper East',
        'GH-UW' => 'Upper West',
        'GH-TV' => 'Volta',
        'GH-WP' => 'Western',
    ],
    'GL' => [
        'GL-KU' => 'Kommune Kujalleq',
        'GL-SM' => 'Kommuneqarfik Sermersooq',
        'GL-QA' => 'Qaasuitsup Kommunia',
        'GL-QE' => 'Qeqqata Kommunia',
    ],
    'GM' => [
        'GM-B' => 'Banjul',
        'GM-M' => 'Central River',
        'GM-L' => 'Lower River',
        'GM-N' => 'North Bank',
        'GM-U' => 'Upper River',
        'GM-W' => 'Western',
    ],
    'GN' => [
        'GN-B' => 'Boké',
        'GN-C' => 'Conakry',
        'GN-F' => 'Faranah',
        'GN-K' => 'Kankan',
        'GN-D' => 'Kindia',
        'GN-L' => 'Labé',
        'GN-M' => 'Mamou',
        'GN-N' => 'Nzérékoré',
    ],
    'GQ' => [
        'GQ-C' => 'Región Continental',
        'GQ-I' => 'Región Insular',
    ],
    'GR' => [
        'GR-A' => 'Anatolikí Makedonía kai Thráki',
        'GR-I' => 'Attikí',
        'GR-G' => 'Dytikí Elláda',
        'GR-C' => 'Dytikí Makedonía',
        'GR-F' => 'Ionía Nísia',
        'GR-B' => 'Kentrikí Makedonía',
        'GR-M' => 'Kríti',
        'GR-L' => 'Notío Aigaío',
        'GR-J' => 'Peloponnísos',
        'GR-H' => 'Stereá Elláda',
        'GR-E' => 'Thessalía',
        'GR-K' => 'Voreío Aigaío',
        'GR-69' => 'Ágion Óros',
        'GR-D' => 'Ípeiros',
    ],
    'GT' => [
        'GT-AV' => 'Alta Verapaz',
        'GT-BV' => 'Baja Verapaz',
        'GT-CM' => 'Chimaltenango',
        'GT-CQ' => 'Chiquimula',
        'GT-PR' => 'El Progreso',
        'GT-ES' => 'Escuintla',
        'GT-GU' => 'Guatemala',
        'GT-HU' => 'Huehuetenango',
        'GT-IZ' => 'Izabal',
        'GT-JA' => 'Jalapa',
        'GT-JU' => 'Jutiapa',
        'GT-PE' => 'Petén',
        'GT-QZ' => 'Quetzaltenango',
        'GT-QC' => 'Quiché',
        'GT-RE' => 'Retalhuleu',
        'GT-SA' => 'Sacatepéquez',
        'GT-SM' => 'San Marcos',
        'GT-SR' => 'Santa Rosa',
        'GT-SO' => 'Sololá',
        'GT-SU' => 'Suchitepéquez',
        'GT-TO' => 'Totonicapán',
        'GT-ZA' => 'Zacapa',
    ],
    'GW' => [
        'GW-BS' => 'Bissau',
        'GW-L' => 'Leste',
        'GW-N' => 'Norte',
        'GW-S' => 'Sul',
    ],
    'GY' => [
        'GY-BA' => 'Barima-Waini',
        'GY-CU' => 'Cuyuni-Mazaruni',
        'GY-DE' => 'Demerara-Mahaica',
        'GY-EB' => 'East Berbice-Corentyne',
        'GY-ES' => 'Essequibo Islands-West Demerara',
        'GY-MA' => 'Mahaica-Berbice',
        'GY-PM' => 'Pomeroon-Supenaam',
        'GY-PT' => 'Potaro-Siparuni',
        'GY-UD' => 'Upper Demerara-Berbice',
        'GY-UT' => 'Upper Takutu-Upper Essequibo',
    ],
    'HN' => [
        'HN-AT' => 'Atlántida',
        'HN-CH' => 'Choluteca',
        'HN-CL' => 'Colón',
        'HN-CM' => 'Comayagua',
        'HN-CP' => 'Copán',
        'HN-CR' => 'Cortés',
        'HN-EP' => 'El Paraíso',
        'HN-FM' => 'Francisco Morazán',
        'HN-GD' => 'Gracias a Dios',
        'HN-IN' => 'Intibucá',
        'HN-IB' => 'Islas de la Bahía',
        'HN-LP' => 'La Paz',
        'HN-LE' => 'Lempira',
        'HN-OC' => 'Ocotepeque',
        'HN-OL' => 'Olancho',
        'HN-SB' => 'Santa Bárbara',
        'HN-VA' => 'Valle',
        'HN-YO' => 'Yoro',
    ],
    'HR' => [
        'HR-07' => 'Bjelovarsko-bilogorska županija',
        'HR-12' => 'Brodsko-posavska županija',
        'HR-19' => 'Dubrovačko-neretvanska županija',
        'HR-21' => 'Grad Zagreb',
        'HR-18' => 'Istarska županija',
        'HR-04' => 'Karlovačka županija',
        'HR-06' => 'Koprivničko-križevačka županija',
        'HR-02' => 'Krapinsko-zagorska županija',
        'HR-09' => 'Ličko-senjska županija',
        'HR-20' => 'Međimurska županija',
        'HR-14' => 'Osječko-baranjska županija',
        'HR-11' => 'Požeško-slavonska županija',
        'HR-08' => 'Primorsko-goranska županija',
        'HR-03' => 'Sisačko-moslavačka županija',
        'HR-17' => 'Splitsko-dalmatinska županija',
        'HR-05' => 'Varaždinska županija',
        'HR-10' => 'Virovitičko-podravska županija',
        'HR-16' => 'Vukovarsko-srijemska županija',
        'HR-13' => 'Zadarska županija',
        'HR-01' => 'Zagrebačka županija',
        'HR-15' => 'Šibensko-kninska županija',
    ],
    'HT' => [
        'HT-AR' => 'Artibonite',
        'HT-CE' => 'Centre',
        'HT-GA' => 'Grande’Anse',
        'HT-NI' => 'Nippes',
        'HT-ND' => 'Nord',
        'HT-NE' => 'Nord-Est',
        'HT-NO' => 'Nord-Ouest',
        'HT-OU' => 'Ouest',
        'HT-SD' => 'Sud',
        'HT-SE' => 'Sud-Est',
    ],
    'HU' => [
        'HU-BA' => 'Baranya',
        'HU-BZ' => 'Borsod-Abaúj-Zemplén',
        'HU-BU' => 'Budapest',
        'HU-BK' => 'Bács-Kiskun',
        'HU-BE' => 'Békés',
        'HU-BC' => 'Békéscsaba',
        'HU-CS' => 'Csongrád',
        'HU-DE' => 'Debrecen',
        'HU-DU' => 'Dunaújváros',
        'HU-EG' => 'Eger',
        'HU-FE' => 'Fejér',
        'HU-GY' => 'Győr',
        'HU-GS' => 'Győr-Moson-Sopron',
        'HU-HB' => 'Hajdú-Bihar',
        'HU-HE' => 'Heves',
        'HU-HV' => 'Hódmezővásárhely',
        'HU-JN' => 'Jász-Nagykun-Szolnok',
        'HU-KV' => 'Kaposvár',
        'HU-KM' => 'Kecskemét',
        'HU-KE' => 'Komárom-Esztergom',
        'HU-MI' => 'Miskolc',
        'HU-NK' => 'Nagykanizsa',
        'HU-NY' => 'Nyíregyháza',
        'HU-NO' => 'Nógrád',
        'HU-PE' => 'Pest',
        'HU-PS' => 'Pécs',
        'HU-ST' => 'Salgótarján',
        'HU-SO' => 'Somogy',
        'HU-SN' => 'Sopron',
        'HU-SZ' => 'Szabolcs-Szatmár-Bereg',
        'HU-SD' => 'Szeged',
        'HU-SS' => 'Szekszárd',
        'HU-SK' => 'Szolnok',
        'HU-SH' => 'Szombathely',
        'HU-SF' => 'Székesfehérvár',
        'HU-TB' => 'Tatabánya',
        'HU-TO' => 'Tolna',
        'HU-VA' => 'Vas',
        'HU-VE' => 'Veszprém',
        'HU-VM' => 'Veszprém',
        'HU-ZA' => 'Zala',
        'HU-ZE' => 'Zalaegerszeg',
        'HU-ER' => 'Érd',
    ],
    'ID' => [
        'ID-JW' => 'Jawa',
        'ID-KA' => 'Kalimantan',
        'ID-ML' => 'Maluku',
        'ID-NU' => 'Nusa Tenggara',
        'ID-PP' => 'Papua',
        'ID-SL' => 'Sulawesi',
        'ID-SM' => 'Sumatera',
    ],
    'IE' => [
        'IE-C' => 'Connaught',
        'IE-L' => 'Leinster',
        'IE-M' => 'Munster',
        'IE-U' => 'Ulster',
    ],
    'IL' => [
        'IL-M' => 'Al Awsaţ',
        'IL-D' => 'Al Janūbī',
        'IL-JM' => 'Al Quds',
        'IL-Z' => 'Ash Shamālī',
        'IL-TA' => 'Tall Abīb',
        'IL-HA' => 'Ḩayfā',
    ],
    'IN' => [
        'IN-AN' => 'Andaman and Nicobar Islands',
        'IN-AP' => 'Andhra Pradesh',
        'IN-AR' => 'Arunachal Pradesh',
        'IN-AS' => 'Assam',
        'IN-BR' => 'Bihar',
        'IN-CH' => 'Chandigarh',
        'IN-CT' => 'Chhattisgarh',
        'IN-DN' => 'Dadra and Nagar Haveli',
        'IN-DD' => 'Daman and Diu',
        'IN-DL' => 'Delhi',
        'IN-GA' => 'Goa',
        'IN-GJ' => 'Gujarat',
        'IN-HR' => 'Haryana',
        'IN-HP' => 'Himachal Pradesh',
        'IN-JK' => 'Jammu and Kashmir',
        'IN-JH' => 'Jharkhand',
        'IN-KA' => 'Karnataka',
        'IN-KL' => 'Kerala',
        'IN-LD' => 'Lakshadweep',
        'IN-MP' => 'Madhya Pradesh',
        'IN-MH' => 'Maharashtra',
        'IN-MN' => 'Manipur',
        'IN-ML' => 'Meghalaya',
        'IN-MZ' => 'Mizoram',
        'IN-NL' => 'Nagaland',
        'IN-OR' => 'Odisha',
        'IN-PY' => 'Puducherry',
        'IN-PB' => 'Punjab',
        'IN-RJ' => 'Rajasthan',
        'IN-SK' => 'Sikkim',
        'IN-TN' => 'Tamil Nadu',
        'IN-TG' => 'Telangana',
        'IN-TR' => 'Tripura',
        'IN-UP' => 'Uttar Pradesh',
        'IN-UT' => 'Uttarakhand',
        'IN-WB' => 'West Bengal',
    ],
    'IQ' => [
        'IQ-DA' => 'Dihok',
        'IQ-AR' => 'Hewlêr',
        'IQ-SU' => 'Slêmanî',
        'IQ-AN' => 'Al Anbār',
        'IQ-BA' => 'Al Başrah',
        'IQ-MU' => 'Al Muthanná',
        'IQ-QA' => 'Al Qādisīyah',
        'IQ-NA' => 'An Najaf',
        'IQ-BG' => 'Baghdād',
        'IQ-BB' => 'Bābil',
        'IQ-DQ' => 'Dhī Qār',
        'IQ-DI' => 'Diyālá',
        'IQ-KA' => 'Karbalā’',
        'IQ-KI' => 'Kirkūk',
        'IQ-MA' => 'Maysān',
        'IQ-NI' => 'Nīnawá',
        'IQ-WA' => 'Wāsiţ',
        'IQ-SD' => 'Şalāḩ ad Dīn',
    ],
    'IR' => [
        'IR-32' => 'Alborz',
        'IR-03' => 'Ardabīl',
        'IR-06' => 'Būshehr',
        'IR-08' => 'Chahār Maḩāl va Bakhtīārī',
        'IR-04' => 'Eşfahān',
        'IR-14' => 'Fārs',
        'IR-27' => 'Golestān',
        'IR-19' => 'Gīlān',
        'IR-24' => 'Hamadān',
        'IR-23' => 'Hormozgān',
        'IR-15' => 'Kermān',
        'IR-17' => 'Kermānshāh',
        'IR-29' => 'Khorāsān-e Jonūbī',
        'IR-30' => 'Khorāsān-e Raẕavī',
        'IR-31' => 'Khorāsān-e Shomālī',
        'IR-10' => 'Khūzestān',
        'IR-18' => 'Kohgīlūyeh va Bowyer Aḩmad',
        'IR-16' => 'Kordestān',
        'IR-20' => 'Lorestān',
        'IR-22' => 'Markazī',
        'IR-21' => 'Māzandarān',
        'IR-28' => 'Qazvīn',
        'IR-26' => 'Qom',
        'IR-12' => 'Semnān',
        'IR-13' => 'Sīstān va Balūchestān',
        'IR-07' => 'Tehrān',
        'IR-25' => 'Yazd',
        'IR-11' => 'Zanjān',
        'IR-02' => 'Āz̄ārbāyjān-e Ghārbī',
        'IR-01' => 'Āz̄ārbāyjān-e Shārqī',
        'IR-05' => 'Īlām',
    ],
    'IS' => [
        'IS-7' => 'Austurland',
        'IS-1' => 'Höfuðborgarsvæði',
        'IS-6' => 'Norðurland eystra',
        'IS-5' => 'Norðurland vestra',
        'IS-8' => 'Suðurland',
        'IS-2' => 'Suðurnes',
        'IS-4' => 'Vestfirðir',
        'IS-3' => 'Vesturland',
    ],
    'IT' => [
        'IT-65' => 'Abruzzo',
        'IT-77' => 'Basilicata',
        'IT-78' => 'Calabria',
        'IT-72' => 'Campania',
        'IT-45' => 'Emilia-Romagna',
        'IT-36' => 'Friuli-Venezia Giulia',
        'IT-62' => 'Lazio',
        'IT-42' => 'Liguria',
        'IT-25' => 'Lombardia',
        'IT-57' => 'Marche',
        'IT-67' => 'Molise',
        'IT-21' => 'Piemonte',
        'IT-75' => 'Puglia',
        'IT-88' => 'Sardegna',
        'IT-82' => 'Sicilia',
        'IT-52' => 'Toscana',
        'IT-32' => 'Trentino-Alto Adige',
        'IT-55' => 'Umbria',
        'IT-23' => 'Valle d\'Aosta',
        'IT-34' => 'Veneto',
    ],
    'JM' => [
        'JM-13' => 'Clarendon',
        'JM-09' => 'Hanover',
        'JM-01' => 'Kingston',
        'JM-12' => 'Manchester',
        'JM-04' => 'Portland',
        'JM-02' => 'Saint Andrew',
        'JM-06' => 'Saint Ann',
        'JM-14' => 'Saint Catherine',
        'JM-11' => 'Saint Elizabeth',
        'JM-08' => 'Saint James',
        'JM-05' => 'Saint Mary',
        'JM-03' => 'Saint Thomas',
        'JM-07' => 'Trelawny',
        'JM-10' => 'Westmoreland',
    ],
    'JO' => [
        'JO-BA' => 'Al Balqā’',
        'JO-KA' => 'Al Karak',
        'JO-MA' => 'Al Mafraq',
        'JO-AQ' => 'Al ‘Aqabah',
        'JO-AM' => 'Al ‘A̅şimah',
        'JO-AZ' => 'Az Zarqā’',
        'JO-AT' => 'Aţ Ţafīlah',
        'JO-IR' => 'Irbid',
        'JO-JA' => 'Jarash',
        'JO-MN' => 'Ma‘ān',
        'JO-MD' => 'Mādabā',
        'JO-AJ' => '‘Ajlūn',
    ],
    'JP' => [
        'JP-23' => 'Aiti',
        'JP-05' => 'Akita',
        'JP-02' => 'Aomori',
        'JP-38' => 'Ehime',
        'JP-21' => 'Gihu',
        'JP-10' => 'Gunma',
        'JP-34' => 'Hirosima',
        'JP-01' => 'Hokkaidô',
        'JP-18' => 'Hukui',
        'JP-40' => 'Hukuoka',
        'JP-07' => 'Hukusima',
        'JP-28' => 'Hyôgo',
        'JP-08' => 'Ibaraki',
        'JP-17' => 'Isikawa',
        'JP-03' => 'Iwate',
        'JP-37' => 'Kagawa',
        'JP-46' => 'Kagosima',
        'JP-14' => 'Kanagawa',
        'JP-43' => 'Kumamoto',
        'JP-26' => 'Kyôto',
        'JP-39' => 'Kôti',
        'JP-24' => 'Mie',
        'JP-04' => 'Miyagi',
        'JP-45' => 'Miyazaki',
        'JP-20' => 'Nagano',
        'JP-42' => 'Nagasaki',
        'JP-29' => 'Nara',
        'JP-15' => 'Niigata',
        'JP-33' => 'Okayama',
        'JP-47' => 'Okinawa',
        'JP-41' => 'Saga',
        'JP-11' => 'Saitama',
        'JP-25' => 'Siga',
        'JP-32' => 'Simane',
        'JP-22' => 'Sizuoka',
        'JP-12' => 'Tiba',
        'JP-36' => 'Tokusima',
        'JP-09' => 'Totigi',
        'JP-31' => 'Tottori',
        'JP-16' => 'Toyama',
        'JP-13' => 'Tôkyô',
        'JP-30' => 'Wakayama',
        'JP-06' => 'Yamagata',
        'JP-35' => 'Yamaguti',
        'JP-19' => 'Yamanasi',
        'JP-44' => 'Ôita',
        'JP-27' => 'Ôsaka',
    ],
    'KE' => [
        'KE-01' => 'Baringo',
        'KE-02' => 'Bomet',
        'KE-03' => 'Bungoma',
        'KE-04' => 'Busia',
        'KE-05' => 'Elgeyo/Marakwet',
        'KE-06' => 'Embu',
        'KE-07' => 'Garissa',
        'KE-08' => 'Homa Bay',
        'KE-09' => 'Isiolo',
        'KE-10' => 'Kajiado',
        'KE-11' => 'Kakamega',
        'KE-12' => 'Kericho',
        'KE-13' => 'Kiambu',
        'KE-14' => 'Kilifi',
        'KE-15' => 'Kirinyaga',
        'KE-16' => 'Kisii',
        'KE-17' => 'Kisumu',
        'KE-18' => 'Kitui',
        'KE-19' => 'Kwale',
        'KE-20' => 'Laikipia',
        'KE-21' => 'Lamu',
        'KE-22' => 'Machakos',
        'KE-23' => 'Makueni',
        'KE-24' => 'Mandera',
        'KE-25' => 'Marsabit',
        'KE-26' => 'Meru',
        'KE-27' => 'Migori',
        'KE-28' => 'Mombasa',
        'KE-29' => 'Murang\'a',
        'KE-30' => 'Nairobi City',
        'KE-31' => 'Nakuru',
        'KE-32' => 'Nandi',
        'KE-33' => 'Narok',
        'KE-34' => 'Nyamira',
        'KE-35' => 'Nyandarua',
        'KE-36' => 'Nyeri',
        'KE-37' => 'Samburu',
        'KE-38' => 'Siaya',
        'KE-39' => 'Taita/Taveta',
        'KE-40' => 'Tana River',
        'KE-41' => 'Tharaka-Nithi',
        'KE-42' => 'Trans Nzoia',
        'KE-43' => 'Turkana',
        'KE-44' => 'Uasin Gishu',
        'KE-45' => 'Vihiga',
        'KE-46' => 'Wajir',
        'KE-47' => 'West Pokot',
    ],
    'KG' => [
        'KG-B' => 'Batken',
        'KG-GB' => 'Bishkek',
        'KG-C' => 'Chüy',
        'KG-J' => 'Jalal-Abad',
        'KG-N' => 'Naryn',
        'KG-O' => 'Osh',
        'KG-GO' => 'Osh',
        'KG-T' => 'Talas',
        'KG-Y' => 'Ysyk-Köl',
    ],
    'KH' => [
        'KH-2' => 'Bătdâmbâng',
        'KH-1' => 'Bântéay Méanchey',
        'KH-3' => 'Kâmpóng Cham',
        'KH-4' => 'Kâmpóng Chhnăng',
        'KH-5' => 'Kâmpóng Spœ',
        'KH-6' => 'Kâmpóng Thum',
        'KH-7' => 'Kâmpôt',
        'KH-8' => 'Kândal',
        'KH-9' => 'Kaôh Kŏng',
        'KH-10' => 'Krâchéh',
        'KH-23' => 'Krŏng Kêb',
        'KH-24' => 'Krŏng Pailĭn',
        'KH-18' => 'Krŏng Preăh Sihanouk',
        'KH-11' => 'Môndól Kiri',
        'KH-22' => 'Ŏtdâr Méanchey',
        'KH-12' => 'Phnum Pénh',
        'KH-15' => 'Poŭthĭsăt',
        'KH-13' => 'Preăh Vihéar',
        'KH-14' => 'Prey Vêng',
        'KH-16' => 'Rôtânôkiri',
        'KH-17' => 'Siĕmréab',
        'KH-19' => 'Stueng Traeng',
        'KH-20' => 'Svay Riĕng',
        'KH-21' => 'Takêv',
        'KH-25' => 'Tbong Khmŭm',
    ],
    'KI' => [
        'KI-G' => 'Gilbert Islands',
        'KI-L' => 'Line Islands',
        'KI-P' => 'Phoenix Islands',
    ],
    'KM' => [
        'KM-G' => 'Anjazījah',
        'KM-A' => 'Anjwān',
        'KM-M' => 'Mūhīlī',
    ],
    'KN' => [
        'KN-N' => 'Nevis',
        'KN-K' => 'Saint Kitts',
    ],
    'KP' => [
        'KP-04' => 'Jakangto',
        'KP-09' => 'Hamkyeongpukto',
        'KP-08' => 'Hamkyeongnamto',
        'KP-06' => 'Hwanghaipukto',
        'KP-05' => 'Hwanghainamto',
        'KP-07' => 'Kangwǒn-do',
        'KP-14' => 'Namp’o',
        'KP-03' => 'Phyeonganpukto',
        'KP-02' => 'Phyeongannamto',
        'KP-01' => 'Phyeongyang',
        'KP-13' => 'Rasǒn',
        'KP-10' => 'Ryangkangto',
    ],
    'KR' => [
        'KR-26' => 'Busan-gwangyeoksi',
        'KR-43' => 'Chungcheongbuk-do',
        'KR-44' => 'Chungcheongnam-do',
        'KR-27' => 'Daegu-gwangyeoksi',
        'KR-30' => 'Daejeon-gwangyeoksi',
        'KR-42' => 'Gangwon-do',
        'KR-29' => 'Gwangju-gwangyeoksi',
        'KR-41' => 'Gyeonggi-do',
        'KR-47' => 'Gyeongsangbuk-do',
        'KR-48' => 'Gyeongsangnam-do',
        'KR-28' => 'Incheon-gwangyeoksi',
        'KR-49' => 'Jeju-teukbyeoljachido',
        'KR-45' => 'Jeollabuk-do',
        'KR-46' => 'Jeollanam-do',
        'KR-50' => 'Sejong',
        'KR-11' => 'Seoul-teukbyeolsi',
        'KR-31' => 'Ulsan-gwangyeoksi',
    ],
    'KW' => [
        'KW-AH' => 'Al Aḩmadī',
        'KW-FA' => 'Al Farwānīyah',
        'KW-JA' => 'Al Jahrā’',
        'KW-KU' => 'Al ‘Āşimah',
        'KW-MU' => 'Mubārak al Kabīr',
        'KW-HA' => 'Ḩawallī',
    ],
    'KZ' => [
        'KZ-ALA' => 'Almaty',
        'KZ-ALM' => 'Almaty oblysy',
        'KZ-AKM' => 'Aqmola oblysy',
        'KZ-AKT' => 'Aqtöbe oblysy',
        'KZ-AST' => 'Astana',
        'KZ-ATY' => 'Atyraū oblysy',
        'KZ-ZAP' => 'Batys Qazaqstan oblysy',
        'KZ-BAY' => 'Bayqongyr',
        'KZ-MAN' => 'Mangghystaū oblysy',
        'KZ-YUZ' => 'Ongtüstik Qazaqstan oblysy',
        'KZ-PAV' => 'Pavlodar oblysy',
        'KZ-KAR' => 'Qaraghandy oblysy',
        'KZ-KUS' => 'Qostanay oblysy',
        'KZ-KZY' => 'Qyzylorda oblysy',
        'KZ-VOS' => 'Shyghys Qazaqstan oblysy',
        'KZ-SEV' => 'Soltüstik Qazaqstan oblysy',
        'KZ-ZHA' => 'Zhambyl oblysy',
    ],
    'LA' => [
        'LA-AT' => 'Attapu',
        'LA-BK' => 'Bokèo',
        'LA-BL' => 'Bolikhamxai',
        'LA-CH' => 'Champasak',
        'LA-HO' => 'Houaphan',
        'LA-KH' => 'Khammouan',
        'LA-LM' => 'Louang Namtha',
        'LA-LP' => 'Louangphabang',
        'LA-OU' => 'Oudômxai',
        'LA-PH' => 'Phôngsali',
        'LA-SL' => 'Salavan',
        'LA-SV' => 'Savannakhét',
        'LA-VI' => 'Viangchan',
        'LA-VT' => 'Viangchan',
        'LA-XA' => 'Xaignabouli',
        'LA-XS' => 'Xaisômboun',
        'LA-XI' => 'Xiangkhouang',
        'LA-XE' => 'Xékong',
    ],
    'LB' => [
        'LB-AK' => '‘Akkār',
        'LB-BI' => 'Béqaa',
        'LB-JA' => 'Liban-Sud',
        'LB-NA' => 'Nabatîyé',
        'LB-AS' => 'Liban-Nord',
        'LB-BH' => 'B‘alabak-Al Hirmil',
        'LB-BA' => 'Beyrouth',
        'LB-JL' => 'Mont-Liban',
    ],
    'LC' => [
        'LC-01' => 'Anse la Raye',
        'LC-12' => 'Canaries',
        'LC-02' => 'Castries',
        'LC-03' => 'Choiseul',
        'LC-05' => 'Dennery',
        'LC-06' => 'Gros Islet',
        'LC-07' => 'Laborie',
        'LC-08' => 'Micoud',
        'LC-10' => 'Soufrière',
        'LC-11' => 'Vieux Fort',
    ],
    'LI' => [
        'LI-01' => 'Balzers',
        'LI-02' => 'Eschen',
        'LI-03' => 'Gamprin',
        'LI-04' => 'Mauren',
        'LI-05' => 'Planken',
        'LI-06' => 'Ruggell',
        'LI-07' => 'Schaan',
        'LI-08' => 'Schellenberg',
        'LI-09' => 'Triesen',
        'LI-10' => 'Triesenberg',
        'LI-11' => 'Vaduz',
    ],
    'LK' => [
        'LK-2' => 'Central Province',
        'LK-5' => 'Eastern Province',
        'LK-7' => 'North Central Province',
        'LK-6' => 'North Western Province',
        'LK-4' => 'Northern Province',
        'LK-9' => 'Sabaragamuwa Province',
        'LK-3' => 'Southern Province',
        'LK-8' => 'Uva Province',
        'LK-1' => 'Western Province',
    ],
    'LR' => [
        'LR-BM' => 'Bomi',
        'LR-BG' => 'Bong',
        'LR-GP' => 'Gbarpolu',
        'LR-GB' => 'Grand Bassa',
        'LR-CM' => 'Grand Cape Mount',
        'LR-GG' => 'Grand Gedeh',
        'LR-GK' => 'Grand Kru',
        'LR-LO' => 'Lofa',
        'LR-MG' => 'Margibi',
        'LR-MY' => 'Maryland',
        'LR-MO' => 'Montserrado',
        'LR-NI' => 'Nimba',
        'LR-RI' => 'River Cess',
        'LR-RG' => 'River Gee',
        'LR-SI' => 'Sinoe',
    ],
    'LS' => [
        'LS-D' => 'Berea',
        'LS-B' => 'Butha-Buthe',
        'LS-C' => 'Leribe',
        'LS-E' => 'Mafeteng',
        'LS-A' => 'Maseru',
        'LS-F' => 'Mohale\'s Hoek',
        'LS-J' => 'Mokhotlong',
        'LS-H' => 'Qacha\'s Nek',
        'LS-G' => 'Quthing',
        'LS-K' => 'Thaba-Tseka',
    ],
    'LT' => [
        'LT-01' => 'Akmenė',
        'LT-AL' => 'Alytaus apskritis',
        'LT-02' => 'Alytaus miestas',
        'LT-03' => 'Alytus',
        'LT-04' => 'Anykščiai',
        'LT-05' => 'Birštono',
        'LT-06' => 'Biržai',
        'LT-07' => 'Druskininkai',
        'LT-08' => 'Elektrėnai',
        'LT-09' => 'Ignalina',
        'LT-10' => 'Jonava',
        'LT-11' => 'Joniškis',
        'LT-12' => 'Jurbarkas',
        'LT-13' => 'Kaišiadorys',
        'LT-14' => 'Kalvarijos',
        'LT-16' => 'Kaunas',
        'LT-KU' => 'Kauno apskritis',
        'LT-15' => 'Kauno miestas',
        'LT-17' => 'Kazlų Rūdos',
        'LT-19' => 'Kelmė',
        'LT-21' => 'Klaipėda',
        'LT-KL' => 'Klaipėdos apskritis',
        'LT-20' => 'Klaipėdos miestas',
        'LT-22' => 'Kretinga',
        'LT-23' => 'Kupiškis',
        'LT-18' => 'Kėdainiai',
        'LT-24' => 'Lazdijai',
        'LT-25' => 'Marijampolė',
        'LT-MR' => 'Marijampolės apskritis',
        'LT-26' => 'Mažeikiai',
        'LT-27' => 'Molėtai',
        'LT-28' => 'Neringa',
        'LT-29' => 'Pagėgiai',
        'LT-30' => 'Pakruojis',
        'LT-31' => 'Palangos miestas',
        'LT-PN' => 'Panevėžio apskritis',
        'LT-32' => 'Panevėžio miestas',
        'LT-33' => 'Panevėžys',
        'LT-34' => 'Pasvalys',
        'LT-35' => 'Plungė',
        'LT-36' => 'Prienai',
        'LT-37' => 'Radviliškis',
        'LT-38' => 'Raseiniai',
        'LT-39' => 'Rietavo',
        'LT-40' => 'Rokiškis',
        'LT-48' => 'Skuodas',
        'LT-50' => 'Tauragė',
        'LT-TA' => 'Tauragės apskritis',
        'LT-51' => 'Telšiai',
        'LT-TE' => 'Telšių apskritis',
        'LT-52' => 'Trakai',
        'LT-53' => 'Ukmergė',
        'LT-54' => 'Utena',
        'LT-UT' => 'Utenos apskritis',
        'LT-55' => 'Varėna',
        'LT-56' => 'Vilkaviškis',
        'LT-VL' => 'Vilniaus apskritis',
        'LT-57' => 'Vilniaus miestas',
        'LT-58' => 'Vilnius',
        'LT-59' => 'Visaginas',
        'LT-60' => 'Zarasai',
        'LT-41' => 'Šakiai',
        'LT-42' => 'Šalčininkai',
        'LT-44' => 'Šiauliai',
        'LT-SA' => 'Šiaulių apskritis',
        'LT-43' => 'Šiaulių miestas',
        'LT-45' => 'Šilalė',
        'LT-46' => 'Šilutė',
        'LT-47' => 'Širvintos',
        'LT-49' => 'Švenčionys',
    ],
    'LU' => [
        'LU-CA' => 'Capellen',
        'LU-CL' => 'Clerf',
        'LU-DI' => 'Diekirch',
        'LU-EC' => 'Echternach',
        'LU-ES' => 'Esch an der Alzette',
        'LU-GR' => 'Grevenmacher',
        'LU-LU' => 'Luxemburg',
        'LU-ME' => 'Mersch',
        'LU-RD' => 'Redingen',
        'LU-RM' => 'Remich',
        'LU-VD' => 'Vianden',
        'LU-WI' => 'Wiltz',
    ],
    'LV' => [
        'LV-001' => 'Aglonas novads',
        'LV-002' => 'Aizkraukles novads',
        'LV-003' => 'Aizputes novads',
        'LV-004' => 'Aknīstes novads',
        'LV-005' => 'Alojas novads',
        'LV-006' => 'Alsungas novads',
        'LV-007' => 'Alūksnes novads',
        'LV-008' => 'Amatas novads',
        'LV-009' => 'Apes novads',
        'LV-010' => 'Auces novads',
        'LV-012' => 'Babītes novads',
        'LV-013' => 'Baldones novads',
        'LV-014' => 'Baltinavas novads',
        'LV-015' => 'Balvu novads',
        'LV-016' => 'Bauskas novads',
        'LV-017' => 'Beverīnas novads',
        'LV-018' => 'Brocēnu novads',
        'LV-019' => 'Burtnieku novads',
        'LV-020' => 'Carnikavas novads',
        'LV-021' => 'Cesvaines novads',
        'LV-023' => 'Ciblas novads',
        'LV-022' => 'Cēsu novads',
        'LV-024' => 'Dagdas novads',
        'LV-DGV' => 'Daugavpils',
        'LV-025' => 'Daugavpils novads',
        'LV-026' => 'Dobeles novads',
        'LV-027' => 'Dundagas novads',
        'LV-028' => 'Durbes novads',
        'LV-029' => 'Engures novads',
        'LV-031' => 'Garkalnes novads',
        'LV-032' => 'Grobiņas novads',
        'LV-033' => 'Gulbenes novads',
        'LV-034' => 'Iecavas novads',
        'LV-035' => 'Ikšķiles novads',
        'LV-036' => 'Ilūkstes novads',
        'LV-037' => 'Inčukalna novads',
        'LV-038' => 'Jaunjelgavas novads',
        'LV-039' => 'Jaunpiebalgas novads',
        'LV-040' => 'Jaunpils novads',
        'LV-JEL' => 'Jelgava',
        'LV-041' => 'Jelgavas novads',
        'LV-JKB' => 'Jēkabpils',
        'LV-042' => 'Jēkabpils novads',
        'LV-JUR' => 'Jūrmala',
        'LV-043' => 'Kandavas novads',
        'LV-045' => 'Kocēnu novads',
        'LV-046' => 'Kokneses novads',
        'LV-048' => 'Krimuldas novads',
        'LV-049' => 'Krustpils novads',
        'LV-047' => 'Krāslavas novads',
        'LV-050' => 'Kuldīgas novads',
        'LV-044' => 'Kārsavas novads',
        'LV-053' => 'Lielvārdes novads',
        'LV-LPX' => 'Liepāja',
        'LV-054' => 'Limbažu novads',
        'LV-057' => 'Lubānas novads',
        'LV-058' => 'Ludzas novads',
        'LV-055' => 'Līgatnes novads',
        'LV-056' => 'Līvānu novads',
        'LV-059' => 'Madonas novads',
        'LV-060' => 'Mazsalacas novads',
        'LV-061' => 'Mālpils novads',
        'LV-062' => 'Mārupes novads',
        'LV-063' => 'Mērsraga novads',
        'LV-064' => 'Naukšēnu novads',
        'LV-065' => 'Neretas novads',
        'LV-066' => 'Nīcas novads',
        'LV-067' => 'Ogres novads',
        'LV-068' => 'Olaines novads',
        'LV-069' => 'Ozolnieku novads',
        'LV-073' => 'Preiļu novads',
        'LV-074' => 'Priekules novads',
        'LV-075' => 'Priekuļu novads',
        'LV-070' => 'Pārgaujas novads',
        'LV-071' => 'Pāvilostas novads',
        'LV-072' => 'Pļaviņu novads',
        'LV-076' => 'Raunas novads',
        'LV-078' => 'Riebiņu novads',
        'LV-079' => 'Rojas novads',
        'LV-080' => 'Ropažu novads',
        'LV-081' => 'Rucavas novads',
        'LV-082' => 'Rugāju novads',
        'LV-083' => 'Rundāles novads',
        'LV-REZ' => 'Rēzekne',
        'LV-077' => 'Rēzeknes novads',
        'LV-RIX' => 'Rīga',
        'LV-084' => 'Rūjienas novads',
        'LV-086' => 'Salacgrīvas novads',
        'LV-085' => 'Salas novads',
        'LV-087' => 'Salaspils novads',
        'LV-088' => 'Saldus novads',
        'LV-089' => 'Saulkrastu novads',
        'LV-091' => 'Siguldas novads',
        'LV-093' => 'Skrundas novads',
        'LV-092' => 'Skrīveru novads',
        'LV-094' => 'Smiltenes novads',
        'LV-095' => 'Stopiņu novads',
        'LV-096' => 'Strenču novads',
        'LV-090' => 'Sējas novads',
        'LV-097' => 'Talsu novads',
        'LV-099' => 'Tukuma novads',
        'LV-098' => 'Tērvetes novads',
        'LV-100' => 'Vaiņodes novads',
        'LV-101' => 'Valkas novads',
        'LV-VMR' => 'Valmiera',
        'LV-102' => 'Varakļānu novads',
        'LV-104' => 'Vecpiebalgas novads',
        'LV-105' => 'Vecumnieku novads',
        'LV-VEN' => 'Ventspils',
        'LV-106' => 'Ventspils novads',
        'LV-107' => 'Viesītes novads',
        'LV-108' => 'Viļakas novads',
        'LV-109' => 'Viļānu novads',
        'LV-103' => 'Vārkavas novads',
        'LV-110' => 'Zilupes novads',
        'LV-011' => 'Ādažu novads',
        'LV-030' => 'Ērgļu novads',
        'LV-051' => 'Ķeguma novads',
        'LV-052' => 'Ķekavas novads',
    ],
    'LY' => [
        'LY-BU' => 'Al Buţnān',
        'LY-JA' => 'Al Jabal al Akhḑar',
        'LY-JG' => 'Al Jabal al Gharbī',
        'LY-JI' => 'Al Jafārah',
        'LY-JU' => 'Al Jufrah',
        'LY-KF' => 'Al Kufrah',
        'LY-MJ' => 'Al Marj',
        'LY-MB' => 'Al Marqab',
        'LY-WA' => 'Al Wāḩāt',
        'LY-NQ' => 'An Nuqāţ al Khams',
        'LY-ZA' => 'Az Zāwiyah',
        'LY-BA' => 'Banghāzī',
        'LY-DR' => 'Darnah',
        'LY-GT' => 'Ghāt',
        'LY-MI' => 'Mişrātah',
        'LY-MQ' => 'Murzuq',
        'LY-NL' => 'Nālūt',
        'LY-SB' => 'Sabhā',
        'LY-SR' => 'Surt',
        'LY-WD' => 'Wādī al Ḩayāt',
        'LY-WS' => 'Wādī ash Shāţi’',
        'LY-TB' => 'Ţarābulus',
    ],
    'MA' => [
        'MA-05' => 'Béni-Mellal-Khénifra',
        'MA-06' => 'Casablanca-Settat',
        'MA-12' => 'Dakhla-Oued Ed-Dahab (EH)',
        'MA-08' => 'Drâa-Tafilalet',
        'MA-03' => 'Fès- Meknès',
        'MA-10' => 'Guelmim-Oued Noun (EH-partial)',
        'MA-02' => 'L\'Oriental',
        'MA-11' => 'Laâyoune-Sakia El Hamra (EH-partial)',
        'MA-07' => 'Marrakech-Safi',
        'MA-04' => 'Rabat-Salé-Kénitra',
        'MA-09' => 'Souss-Massa',
        'MA-01' => 'Tanger-Tétouan-Al Hoceïma',
    ],
    'MC' => [
        'MC-FO' => 'Fontvieille',
        'MC-JE' => 'Jardin Exotique',
        'MC-CL' => 'La Colle',
        'MC-CO' => 'La Condamine',
        'MC-GA' => 'La Gare',
        'MC-SO' => 'La Source',
        'MC-LA' => 'Larvotto',
        'MC-MA' => 'Malbousquet',
        'MC-MO' => 'Monaco-Ville',
        'MC-MG' => 'Moneghetti',
        'MC-MC' => 'Monte-Carlo',
        'MC-MU' => 'Moulins',
        'MC-PH' => 'Port-Hercule',
        'MC-SR' => 'Saint-Roman',
        'MC-SD' => 'Sainte-Dévote',
        'MC-SP' => 'Spélugues',
        'MC-VR' => 'Vallon de la Rousse',
    ],
    'MD' => [
        'MD-AN' => 'Anenii Noi',
        'MD-BS' => 'Basarabeasca',
        'MD-BD' => 'Bender [Tighina]',
        'MD-BR' => 'Briceni',
        'MD-BA' => 'Bălți',
        'MD-CA' => 'Cahul',
        'MD-CT' => 'Cantemir',
        'MD-CU' => 'Chișinău',
        'MD-CM' => 'Cimișlia',
        'MD-CR' => 'Criuleni',
        'MD-CL' => 'Călărași',
        'MD-CS' => 'Căușeni',
        'MD-DO' => 'Dondușeni',
        'MD-DR' => 'Drochia',
        'MD-DU' => 'Dubăsari',
        'MD-ED' => 'Edineț',
        'MD-FL' => 'Florești',
        'MD-FA' => 'Fălești',
        'MD-GL' => 'Glodeni',
        'MD-GA' => 'Găgăuzia, Unitatea teritorială autonomă (UTAG)',
        'MD-HI' => 'Hîncești',
        'MD-IA' => 'Ialoveni',
        'MD-LE' => 'Leova',
        'MD-NI' => 'Nisporeni',
        'MD-OC' => 'Ocnița',
        'MD-OR' => 'Orhei',
        'MD-RE' => 'Rezina',
        'MD-RI' => 'Rîșcani',
        'MD-SO' => 'Soroca',
        'MD-ST' => 'Strășeni',
        'MD-SN' => 'Stînga Nistrului, unitatea teritorială din',
        'MD-SI' => 'Sîngerei',
        'MD-TA' => 'Taraclia',
        'MD-TE' => 'Telenești',
        'MD-UN' => 'Ungheni',
        'MD-SD' => 'Șoldănești',
        'MD-SV' => 'Ștefan Vodă',
    ],
    'MG' => [
        'MG-T' => 'Antananarivo',
        'MG-D' => 'Antsiranana',
        'MG-F' => 'Fianarantsoa',
        'MG-M' => 'Mahajanga',
        'MG-A' => 'Toamasina',
        'MG-U' => 'Toliara',
    ],
    'MH' => [
        'MH-L' => 'Ralik chain',
        'MH-T' => 'Ratak chain',
    ],
    'MK' => [
        'MK-02' => 'Aračinovo',
        'MK-03' => 'Berovo',
        'MK-04' => 'Bitola',
        'MK-05' => 'Bogdanci',
        'MK-06' => 'Bogovinje',
        'MK-07' => 'Bosilovo',
        'MK-08' => 'Brvenica',
        'MK-78' => 'Centar Župa',
        'MK-21' => 'Debar',
        'MK-22' => 'Debarca',
        'MK-23' => 'Delčevo',
        'MK-25' => 'Demir Hisar',
        'MK-24' => 'Demir Kapija',
        'MK-26' => 'Dojran',
        'MK-27' => 'Dolneni',
        'MK-18' => 'Gevgelija',
        'MK-19' => 'Gostivar',
        'MK-20' => 'Gradsko',
        'MK-34' => 'Ilinden',
        'MK-35' => 'Jegunovce',
        'MK-37' => 'Karbinci',
        'MK-36' => 'Kavadarci',
        'MK-40' => 'Kičevo',
        'MK-41' => 'Konče',
        'MK-42' => 'Kočani',
        'MK-43' => 'Kratovo',
        'MK-44' => 'Kriva Palanka',
        'MK-45' => 'Krivogaštani',
        'MK-46' => 'Kruševo',
        'MK-47' => 'Kumanovo',
        'MK-48' => 'Lipkovo',
        'MK-49' => 'Lozovo',
        'MK-51' => 'Makedonska Kamenica',
        'MK-52' => 'Makedonski Brod',
        'MK-50' => 'Mavrovo i Rostuša',
        'MK-53' => 'Mogila',
        'MK-54' => 'Negotino',
        'MK-55' => 'Novaci',
        'MK-56' => 'Novo Selo',
        'MK-58' => 'Ohrid',
        'MK-60' => 'Pehčevo',
        'MK-59' => 'Petrovec',
        'MK-61' => 'Plasnica',
        'MK-62' => 'Prilep',
        'MK-63' => 'Probištip',
        'MK-64' => 'Radoviš',
        'MK-65' => 'Rankovce',
        'MK-66' => 'Resen',
        'MK-67' => 'Rosoman',
        'MK-85' => 'Skopje',
        'MK-70' => 'Sopište',
        'MK-71' => 'Staro Nagoričane',
        'MK-72' => 'Struga',
        'MK-73' => 'Strumica',
        'MK-74' => 'Studeničani',
        'MK-69' => 'Sveti Nikole',
        'MK-75' => 'Tearce',
        'MK-76' => 'Tetovo',
        'MK-10' => 'Valandovo',
        'MK-11' => 'Vasilevo',
        'MK-13' => 'Veles',
        'MK-12' => 'Vevčani',
        'MK-14' => 'Vinica',
        'MK-16' => 'Vrapčište',
        'MK-32' => 'Zelenikovo',
        'MK-33' => 'Zrnovci',
        'MK-80' => 'Čaška',
        'MK-81' => 'Češinovo-Obleševo',
        'MK-82' => 'Čučer Sandevo',
        'MK-83' => 'Štip',
        'MK-30' => 'Želino',
    ],
    'ML' => [
        'ML-BKO' => 'Bamako',
        'ML-7' => 'Gao',
        'ML-1' => 'Kayes',
        'ML-8' => 'Kidal',
        'ML-2' => 'Koulikoro',
        'ML-5' => 'Mopti',
        'ML-9' => 'Ménaka',
        'ML-3' => 'Sikasso',
        'ML-4' => 'Ségou',
        'ML-10' => 'Taoudénit',
        'ML-6' => 'Tombouctou',
    ],
    'MM' => [
        'MM-07' => 'Ayeyarwady',
        'MM-02' => 'Bago',
        'MM-14' => 'Chin',
        'MM-11' => 'Kachin',
        'MM-12' => 'Kayah',
        'MM-13' => 'Kayin',
        'MM-03' => 'Magway',
        'MM-04' => 'Mandalay',
        'MM-15' => 'Mon',
        'MM-18' => 'Nay Pyi Taw',
        'MM-16' => 'Rakhine',
        'MM-01' => 'Sagaing',
        'MM-17' => 'Shan',
        'MM-05' => 'Tanintharyi',
        'MM-06' => 'Yangon',
    ],
    'MN' => [
        'MN-073' => 'Arhangay',
        'MN-071' => 'Bayan-Ölgiy',
        'MN-069' => 'Bayanhongor',
        'MN-067' => 'Bulgan',
        'MN-037' => 'Darhan uul',
        'MN-061' => 'Dornod',
        'MN-063' => 'Dornogovĭ',
        'MN-059' => 'Dundgovĭ',
        'MN-057' => 'Dzavhan',
        'MN-065' => 'Govĭ-Altay',
        'MN-064' => 'Govĭ-Sümber',
        'MN-039' => 'Hentiy',
        'MN-043' => 'Hovd',
        'MN-041' => 'Hövsgöl',
        'MN-035' => 'Orhon',
        'MN-049' => 'Selenge',
        'MN-051' => 'Sühbaatar',
        'MN-047' => 'Töv',
        'MN-1' => 'Ulaanbaatar',
        'MN-046' => 'Uvs',
        'MN-053' => 'Ömnögovĭ',
        'MN-055' => 'Övörhangay',
    ],
    'MR' => [
        'MR-07' => 'Adrar',
        'MR-03' => 'Assaba',
        'MR-05' => 'Brakna',
        'MR-08' => 'Dakhlet Nouâdhibou',
        'MR-04' => 'Gorgol',
        'MR-10' => 'Guidimaka',
        'MR-01' => 'Hodh ech Chargui',
        'MR-02' => 'Hodh el Gharbi',
        'MR-12' => 'Inchiri',
        'MR-13' => 'Nuwākshūţ al Gharbīyah',
        'MR-15' => 'Nuwākshūţ al Janūbīyah',
        'MR-14' => 'Nuwākshūţ ash Shamālīyah',
        'MR-09' => 'Tagant',
        'MR-11' => 'Tiris Zemmour',
        'MR-06' => 'Trarza',
    ],
    'MT' => [
        'MT-01' => 'Attard',
        'MT-02' => 'Balzan',
        'MT-03' => 'Birgu',
        'MT-04' => 'Birkirkara',
        'MT-05' => 'Birżebbuġa',
        'MT-06' => 'Bormla',
        'MT-07' => 'Dingli',
        'MT-08' => 'Fgura',
        'MT-09' => 'Floriana',
        'MT-10' => 'Fontana',
        'MT-11' => 'Gudja',
        'MT-13' => 'Għajnsielem',
        'MT-14' => 'Għarb',
        'MT-15' => 'Għargħur',
        'MT-16' => 'Għasri',
        'MT-17' => 'Għaxaq',
        'MT-12' => 'Gżira',
        'MT-19' => 'Iklin',
        'MT-20' => 'Isla',
        'MT-21' => 'Kalkara',
        'MT-22' => 'Kerċem',
        'MT-23' => 'Kirkop',
        'MT-24' => 'Lija',
        'MT-25' => 'Luqa',
        'MT-26' => 'Marsa',
        'MT-27' => 'Marsaskala',
        'MT-28' => 'Marsaxlokk',
        'MT-29' => 'Mdina',
        'MT-30' => 'Mellieħa',
        'MT-32' => 'Mosta',
        'MT-33' => 'Mqabba',
        'MT-34' => 'Msida',
        'MT-35' => 'Mtarfa',
        'MT-36' => 'Munxar',
        'MT-31' => 'Mġarr',
        'MT-37' => 'Nadur',
        'MT-38' => 'Naxxar',
        'MT-39' => 'Paola',
        'MT-40' => 'Pembroke',
        'MT-41' => 'Pietà',
        'MT-42' => 'Qala',
        'MT-43' => 'Qormi',
        'MT-44' => 'Qrendi',
        'MT-45' => 'Rabat Gozo',
        'MT-46' => 'Rabat Malta',
        'MT-47' => 'Safi',
        'MT-49' => 'Saint John',
        'MT-48' => 'Saint Julian\'s',
        'MT-50' => 'Saint Lawrence',
        'MT-53' => 'Saint Lucia\'s',
        'MT-51' => 'Saint Paul\'s Bay',
        'MT-52' => 'Sannat',
        'MT-54' => 'Santa Venera',
        'MT-55' => 'Siġġiewi',
        'MT-56' => 'Sliema',
        'MT-57' => 'Swieqi',
        'MT-58' => 'Ta\' Xbiex',
        'MT-59' => 'Tarxien',
        'MT-60' => 'Valletta',
        'MT-61' => 'Xagħra',
        'MT-62' => 'Xewkija',
        'MT-63' => 'Xgħajra',
        'MT-18' => 'Ħamrun',
        'MT-64' => 'Żabbar',
        'MT-65' => 'Żebbuġ Gozo',
        'MT-66' => 'Żebbuġ Malta',
        'MT-67' => 'Żejtun',
        'MT-68' => 'Żurrieq',
    ],
    'MU' => [
        'MU-AG' => 'Agalega Islands',
        'MU-BR' => 'Beau Bassin-Rose Hill',
        'MU-BL' => 'Black River',
        'MU-CC' => 'Cargados Carajos Shoals',
        'MU-CU' => 'Curepipe',
        'MU-FL' => 'Flacq',
        'MU-GP' => 'Grand Port',
        'MU-MO' => 'Moka',
        'MU-PA' => 'Pamplemousses',
        'MU-PW' => 'Plaines Wilhems',
        'MU-PL' => 'Port Louis',
        'MU-PU' => 'Port Louis',
        'MU-QB' => 'Quatre Bornes',
        'MU-RR' => 'Rivière du Rempart',
        'MU-RO' => 'Rodrigues Island',
        'MU-SA' => 'Savanne',
        'MU-VP' => 'Vacoas-Phoenix',
    ],
    'MV' => [
        'MV-SU' => 'Dhekunu',
        'MV-MLE' => 'Maale',
        'MV-US' => 'Mathi-Dhekunu',
        'MV-UN' => 'Mathi-Uthuru',
        'MV-CE' => 'Medhu',
        'MV-SC' => 'Medhu-Dhekunu',
        'MV-NC' => 'Medhu-Uthuru',
        'MV-NO' => 'Uthuru',
    ],
    'MW' => [
        'MW-C' => 'Central Region',
        'MW-N' => 'Northern Region',
        'MW-S' => 'Southern Region',
    ],
    'MX' => [
        'MX-AGU' => 'Aguascalientes',
        'MX-BCN' => 'Baja California',
        'MX-BCS' => 'Baja California Sur',
        'MX-CAM' => 'Campeche',
        'MX-CHP' => 'Chiapas',
        'MX-CHH' => 'Chihuahua',
        'MX-CMX' => 'Ciudad de México',
        'MX-COA' => 'Coahuila de Zaragoza',
        'MX-COL' => 'Colima',
        'MX-DUR' => 'Durango',
        'MX-GUA' => 'Guanajuato',
        'MX-GRO' => 'Guerrero',
        'MX-HID' => 'Hidalgo',
        'MX-JAL' => 'Jalisco',
        'MX-MIC' => 'Michoacán de Ocampo',
        'MX-MOR' => 'Morelos',
        'MX-MEX' => 'México',
        'MX-NAY' => 'Nayarit',
        'MX-NLE' => 'Nuevo León',
        'MX-OAX' => 'Oaxaca',
        'MX-PUE' => 'Puebla',
        'MX-QUE' => 'Querétaro',
        'MX-ROO' => 'Quintana Roo',
        'MX-SLP' => 'San Luis Potosí',
        'MX-SIN' => 'Sinaloa',
        'MX-SON' => 'Sonora',
        'MX-TAB' => 'Tabasco',
        'MX-TAM' => 'Tamaulipas',
        'MX-TLA' => 'Tlaxcala',
        'MX-VER' => 'Veracruz de Ignacio de la Llave',
        'MX-YUC' => 'Yucatán',
        'MX-ZAC' => 'Zacatecas',
    ],
    'MY' => [
        'MY-01' => 'Johor',
        'MY-02' => 'Kedah',
        'MY-03' => 'Kelantan',
        'MY-04' => 'Melaka',
        'MY-05' => 'Negeri Sembilan',
        'MY-06' => 'Pahang',
        'MY-08' => 'Perak',
        'MY-09' => 'Perlis',
        'MY-07' => 'Pulau Pinang',
        'MY-12' => 'Sabah',
        'MY-13' => 'Sarawak',
        'MY-10' => 'Selangor',
        'MY-11' => 'Terengganu',
        'MY-14' => 'Wilayah Persekutuan Kuala Lumpur',
        'MY-15' => 'Wilayah Persekutuan Labuan',
        'MY-16' => 'Wilayah Persekutuan Putrajaya',
    ],
    'MZ' => [
        'MZ-P' => 'Cabo Delgado',
        'MZ-G' => 'Gaza',
        'MZ-I' => 'Inhambane',
        'MZ-B' => 'Manica',
        'MZ-L' => 'Maputo',
        'MZ-MPM' => 'Maputo',
        'MZ-N' => 'Nampula',
        'MZ-A' => 'Niassa',
        'MZ-S' => 'Sofala',
        'MZ-T' => 'Tete',
        'MZ-Q' => 'Zambézia',
    ],
    'NA' => [
        'NA-ER' => 'Erongo',
        'NA-HA' => 'Hardap',
        'NA-KA' => 'Karas',
        'NA-KE' => 'Kavango East',
        'NA-KW' => 'Kavango West',
        'NA-KH' => 'Khomas',
        'NA-KU' => 'Kunene',
        'NA-OW' => 'Ohangwena',
        'NA-OH' => 'Omaheke',
        'NA-OS' => 'Omusati',
        'NA-ON' => 'Oshana',
        'NA-OT' => 'Oshikoto',
        'NA-OD' => 'Otjozondjupa',
        'NA-CA' => 'Zambezi',
    ],
    'NE' => [
        'NE-1' => 'Agadez',
        'NE-2' => 'Diffa',
        'NE-3' => 'Dosso',
        'NE-4' => 'Maradi',
        'NE-8' => 'Niamey',
        'NE-5' => 'Tahoua',
        'NE-6' => 'Tillabéri',
        'NE-7' => 'Zinder',
    ],
    'NG' => [
        'NG-AB' => 'Abia',
        'NG-FC' => 'Abuja Federal Capital Territory',
        'NG-AD' => 'Adamawa',
        'NG-AK' => 'Akwa Ibom',
        'NG-AN' => 'Anambra',
        'NG-BA' => 'Bauchi',
        'NG-BY' => 'Bayelsa',
        'NG-BE' => 'Benue',
        'NG-BO' => 'Borno',
        'NG-CR' => 'Cross River',
        'NG-DE' => 'Delta',
        'NG-EB' => 'Ebonyi',
        'NG-ED' => 'Edo',
        'NG-EK' => 'Ekiti',
        'NG-EN' => 'Enugu',
        'NG-GO' => 'Gombe',
        'NG-IM' => 'Imo',
        'NG-JI' => 'Jigawa',
        'NG-KD' => 'Kaduna',
        'NG-KN' => 'Kano',
        'NG-KT' => 'Katsina',
        'NG-KE' => 'Kebbi',
        'NG-KO' => 'Kogi',
        'NG-KW' => 'Kwara',
        'NG-LA' => 'Lagos',
        'NG-NA' => 'Nasarawa',
        'NG-NI' => 'Niger',
        'NG-OG' => 'Ogun',
        'NG-ON' => 'Ondo',
        'NG-OS' => 'Osun',
        'NG-OY' => 'Oyo',
        'NG-PL' => 'Plateau',
        'NG-RI' => 'Rivers',
        'NG-SO' => 'Sokoto',
        'NG-TA' => 'Taraba',
        'NG-YO' => 'Yobe',
        'NG-ZA' => 'Zamfara',
    ],
    'NI' => [
        'NI-BO' => 'Boaco',
        'NI-CA' => 'Carazo',
        'NI-CI' => 'Chinandega',
        'NI-CO' => 'Chontales',
        'NI-AN' => 'Costa Caribe Norte',
        'NI-AS' => 'Costa Caribe Sur',
        'NI-ES' => 'Estelí',
        'NI-GR' => 'Granada',
        'NI-JI' => 'Jinotega',
        'NI-LE' => 'León',
        'NI-MD' => 'Madriz',
        'NI-MN' => 'Managua',
        'NI-MS' => 'Masaya',
        'NI-MT' => 'Matagalpa',
        'NI-NS' => 'Nueva Segovia',
        'NI-RI' => 'Rivas',
        'NI-SJ' => 'Río San Juan',
    ],
    'NL' => [
        'NL-AW' => 'Aruba (see also separate country code entry under AW)',
        'NL-BQ1' => 'Bonaire (see also separate country code entry under BQ)',
        'NL-CW' => 'Curaçao (see also separate country code entry under CW)',
        'NL-DR' => 'Drenthe',
        'NL-FL' => 'Flevoland',
        'NL-GE' => 'Gelderland',
        'NL-GR' => 'Groningen',
        'NL-LI' => 'Limburg',
        'NL-NB' => 'Noord-Brabant',
        'NL-NH' => 'Noord-Holland',
        'NL-OV' => 'Overijssel',
        'NL-BQ2' => 'Saba (see also separate country code entry under BQ)',
        'NL-BQ3' => 'Sint Eustatius (see also separate country code entry under BQ)',
        'NL-SX' => 'Sint Maarten (see also separate country code entry under SX)',
        'NL-UT' => 'Utrecht',
        'NL-ZE' => 'Zeeland',
        'NL-ZH' => 'Zuid-Holland',
        'NL-FR' => 'Fryslân',
    ],
    'NO' => [
        'NO-02' => 'Akershus',
        'NO-09' => 'Aust-Agder',
        'NO-06' => 'Buskerud',
        'NO-20' => 'Finnmark',
        'NO-04' => 'Hedmark',
        'NO-12' => 'Hordaland',
        'NO-22' => 'Jan Mayen (Arctic Region) (see also separate country code entry under SJ)',
        'NO-15' => 'Møre og Romsdal',
        'NO-17' => 'Nord-Trøndelag',
        'NO-18' => 'Nordland',
        'NO-05' => 'Oppland',
        'NO-03' => 'Oslo',
        'NO-11' => 'Rogaland',
        'NO-14' => 'Sogn og Fjordane',
        'NO-21' => 'Svalbard (Arctic Region) (see also separate country code entry under SJ)',
        'NO-16' => 'Sør-Trøndelag',
        'NO-08' => 'Telemark',
        'NO-19' => 'Troms',
        'NO-10' => 'Vest-Agder',
        'NO-07' => 'Vestfold',
        'NO-01' => 'Østfold',
    ],
    'NP' => [
        'NP-2' => 'Madhya Pashchimanchal',
        'NP-1' => 'Madhyamanchal',
        'NP-3' => 'Pashchimanchal',
        'NP-4' => 'Purwanchal',
        'NP-5' => 'Sudur Pashchimanchal',
    ],
    'NR' => [
        'NR-01' => 'Aiwo',
        'NR-02' => 'Anabar',
        'NR-03' => 'Anetan',
        'NR-04' => 'Anibare',
        'NR-05' => 'Baitsi',
        'NR-06' => 'Boe',
        'NR-07' => 'Buada',
        'NR-08' => 'Denigomodu',
        'NR-09' => 'Ewa',
        'NR-10' => 'Ijuw',
        'NR-11' => 'Meneng',
        'NR-12' => 'Nibok',
        'NR-13' => 'Uaboe',
        'NR-14' => 'Yaren',
    ],
    'NZ' => [
        'NZ-AUK' => 'Auckland',
        'NZ-BOP' => 'Bay of Plenty',
        'NZ-CAN' => 'Canterbury',
        'NZ-CIT' => 'Chatham Islands Territory',
        'NZ-GIS' => 'Gisborne',
        'NZ-HKB' => 'Hawke\'s Bay',
        'NZ-MWT' => 'Manawatu-Wanganui',
        'NZ-MBH' => 'Marlborough',
        'NZ-NSN' => 'Nelson',
        'NZ-NTL' => 'Northland',
        'NZ-OTA' => 'Otago',
        'NZ-STL' => 'Southland',
        'NZ-TKI' => 'Taranaki',
        'NZ-TAS' => 'Tasman',
        'NZ-WGN' => 'Wellington',
        'NZ-WTC' => 'West Coast',
        'NZ-WKO' => 'Waikato',
    ],
    'OM' => [
        'OM-DA' => 'Ad Dākhilīyah',
        'OM-BU' => 'Al Buraymī',
        'OM-WU' => 'Al Wusţá',
        'OM-ZA' => 'Az̧ Z̧āhirah',
        'OM-BJ' => 'Janūb al Bāţinah',
        'OM-SJ' => 'Janūb ash Sharqīyah',
        'OM-MA' => 'Masqaţ',
        'OM-MU' => 'Musandam',
        'OM-BS' => 'Shamāl al Bāţinah',
        'OM-SS' => 'Shamāl ash Sharqīyah',
        'OM-ZU' => 'Z̧ufār',
    ],
    'PA' => [
        'PA-1' => 'Bocas del Toro',
        'PA-4' => 'Chiriquí',
        'PA-2' => 'Coclé',
        'PA-3' => 'Colón',
        'PA-5' => 'Darién',
        'PA-EM' => 'Emberá',
        'PA-KY' => 'Guna Yala',
        'PA-6' => 'Herrera',
        'PA-7' => 'Los Santos',
        'PA-NB' => 'Ngöbe-Buglé',
        'PA-8' => 'Panamá',
        'PA-10' => 'Panamá Oeste',
        'PA-9' => 'Veraguas',
    ],
    'PE' => [
        'PE-AMA' => 'Amasunu',
        'PE-ANC' => 'Ankashu',
        'PE-APU' => 'Apurimaq',
        'PE-ARE' => 'Arikipa',
        'PE-AYA' => 'Ayaquchu',
        'PE-ICA' => 'Ika',
        'PE-JUN' => 'Junin',
        'PE-CAL' => 'Kallao',
        'PE-CUS' => 'Kusku',
        'PE-LAL' => 'La Libertad',
        'PE-LAM' => 'Lambayeque',
        'PE-LIM' => 'Lima',
        'PE-LMA' => 'Lima hatun llaqta',
        'PE-LOR' => 'Luritu',
        'PE-MDD' => 'Madre de Dios',
        'PE-MOQ' => 'Moqwegwa',
        'PE-PAS' => 'Pasqu',
        'PE-PIU' => 'Piura',
        'PE-PUN' => 'Puno',
        'PE-CAJ' => 'Qajamarka',
        'PE-SAM' => 'San Martín',
        'PE-TAC' => 'Takna',
        'PE-TUM' => 'Tumbes',
        'PE-UCA' => 'Ukayali',
        'PE-HUV' => 'Wankawelika',
        'PE-HUC' => 'Wanuku',
    ],
    'PG' => [
        'PG-NSB' => 'Bougainville',
        'PG-CPM' => 'Central',
        'PG-CPK' => 'Chimbu',
        'PG-EBR' => 'East New Britain',
        'PG-ESW' => 'East Sepik',
        'PG-EHG' => 'Eastern Highlands',
        'PG-EPW' => 'Enga',
        'PG-GPK' => 'Gulf',
        'PG-HLA' => 'Hela',
        'PG-JWK' => 'Jiwaka',
        'PG-MPM' => 'Madang',
        'PG-MRL' => 'Manus',
        'PG-MBA' => 'Milne Bay',
        'PG-MPL' => 'Morobe',
        'PG-NCD' => 'National Capital District (Port Moresby)',
        'PG-NIK' => 'New Ireland',
        'PG-NPP' => 'Northern',
        'PG-SHM' => 'Southern Highlands',
        'PG-WBK' => 'West New Britain',
        'PG-SAN' => 'West Sepik',
        'PG-WPD' => 'Western',
        'PG-WHM' => 'Western Highlands',
    ],
    'PH' => [
        'PH-14' => 'Autonomous Region in Muslim Mindanao (ARMM)',
        'PH-05' => 'Bicol (Region V)',
        'PH-02' => 'Cagayan Valley (Region II)',
        'PH-40' => 'Calabarzon (Region IV-A)',
        'PH-13' => 'Caraga (Region XIII)',
        'PH-03' => 'Central Luzon (Region III)',
        'PH-07' => 'Central Visayas (Region VII)',
        'PH-15' => 'Cordillera Administrative Region (CAR)',
        'PH-11' => 'Davao (Region XI)',
        'PH-08' => 'Eastern Visayas (Region VIII)',
        'PH-01' => 'Ilocos (Region I)',
        'PH-41' => 'Mimaropa (Region IV-B)',
        'PH-00' => 'National Capital Region',
        'PH-10' => 'Northern Mindanao (Region X)',
        'PH-12' => 'Soccsksargen (Region XII)',
        'PH-06' => 'Western Visayas (Region VI)',
        'PH-09' => 'Zamboanga Peninsula (Region IX)',
    ],
    'PK' => [
        'PK-JK' => 'Azad Jammu and Kashmir',
        'PK-BA' => 'Balochistan',
        'PK-TA' => 'Federally Administered Tribal Areas',
        'PK-GB' => 'Gilgit-Baltistan',
        'PK-IS' => 'Islamabad',
        'PK-KP' => 'Khyber Pakhtunkhwa',
        'PK-PB' => 'Punjab',
        'PK-SD' => 'Sindh',
    ],
    'PL' => [
        'PL-DS' => 'Dolnośląskie',
        'PL-KP' => 'Kujawsko-pomorskie',
        'PL-LU' => 'Lubelskie',
        'PL-LB' => 'Lubuskie',
        'PL-MZ' => 'Mazowieckie',
        'PL-MA' => 'Małopolskie',
        'PL-OP' => 'Opolskie',
        'PL-PK' => 'Podkarpackie',
        'PL-PD' => 'Podlaskie',
        'PL-PM' => 'Pomorskie',
        'PL-WN' => 'Warmińsko-mazurskie',
        'PL-WP' => 'Wielkopolskie',
        'PL-ZP' => 'Zachodniopomorskie',
        'PL-LD' => 'Łódzkie',
        'PL-SL' => 'Śląskie',
        'PL-SK' => 'Świętokrzyskie',
    ],
    'PS' => [
        'PS-HBN' => 'Al Khalīl',
        'PS-JEM' => 'Al Quds',
        'PS-JRH' => 'Arīḩā wal Aghwār',
        'PS-BTH' => 'Bayt Laḩm',
        'PS-DEB' => 'Dayr al Balaḩ',
        'PS-GZA' => 'Ghazzah',
        'PS-JEN' => 'Janīn',
        'PS-KYS' => 'Khān Yūnis',
        'PS-NBS' => 'Nāblus',
        'PS-QQA' => 'Qalqīlyah',
        'PS-RFH' => 'Rafaḩ',
        'PS-RBH' => 'Rām Allāh wal Bīrah',
        'PS-SLT' => 'Salfīt',
        'PS-NGZ' => 'Shamāl Ghazzah',
        'PS-TBS' => 'Ţūbās',
        'PS-TKM' => 'Ţūlkarm',
    ],
    'PT' => [
        'PT-01' => 'Aveiro',
        'PT-02' => 'Beja',
        'PT-03' => 'Braga',
        'PT-04' => 'Bragança',
        'PT-05' => 'Castelo Branco',
        'PT-06' => 'Coimbra',
        'PT-08' => 'Faro',
        'PT-09' => 'Guarda',
        'PT-10' => 'Leiria',
        'PT-11' => 'Lisboa',
        'PT-12' => 'Portalegre',
        'PT-13' => 'Porto',
        'PT-30' => 'Região Autónoma da Madeira',
        'PT-20' => 'Região Autónoma dos Açores',
        'PT-14' => 'Santarém',
        'PT-15' => 'Setúbal',
        'PT-16' => 'Viana do Castelo',
        'PT-17' => 'Vila Real',
        'PT-18' => 'Viseu',
        'PT-07' => 'Évora',
    ],
    'PW' => [
        'PW-002' => 'Aimeliik',
        'PW-004' => 'Airai',
        'PW-010' => 'Angaur',
        'PW-050' => 'Hatohobei',
        'PW-100' => 'Kayangel',
        'PW-150' => 'Koror',
        'PW-212' => 'Melekeok',
        'PW-214' => 'Ngaraard',
        'PW-218' => 'Ngarchelong',
        'PW-222' => 'Ngardmau',
        'PW-224' => 'Ngatpang',
        'PW-226' => 'Ngchesar',
        'PW-227' => 'Ngeremlengui',
        'PW-228' => 'Ngiwal',
        'PW-350' => 'Peleliu',
        'PW-370' => 'Sonsorol',
    ],
    'PY' => [
        'PY-16' => 'Alto Paraguay',
        'PY-10' => 'Alto Paraná',
        'PY-13' => 'Amambay',
        'PY-ASU' => 'Asunción',
        'PY-19' => 'Boquerón',
        'PY-5' => 'Caaguazú',
        'PY-6' => 'Caazapá',
        'PY-14' => 'Canindeyú',
        'PY-11' => 'Central',
        'PY-1' => 'Concepción',
        'PY-3' => 'Cordillera',
        'PY-4' => 'Guairá',
        'PY-7' => 'Itapúa',
        'PY-8' => 'Misiones',
        'PY-9' => 'Paraguarí',
        'PY-15' => 'Presidente Hayes',
        'PY-2' => 'San Pedro',
        'PY-12' => 'Ñeembucú',
    ],
    'QA' => [
        'QA-DA' => 'Ad Dawḩah',
        'QA-KH' => 'Al Khawr wa adh Dhakhīrah',
        'QA-WA' => 'Al Wakrah',
        'QA-RA' => 'Ar Rayyān',
        'QA-MS' => 'Ash Shamāl',
        'QA-SH' => 'Ash Shīḩānīyah',
        'QA-ZA' => 'Az̧ Z̧a‘āyin',
        'QA-US' => 'Umm Şalāl',
    ],
    'RO' => [
        'RO-AB' => 'Alba',
        'RO-AR' => 'Arad',
        'RO-AG' => 'Argeș',
        'RO-BC' => 'Bacău',
        'RO-BH' => 'Bihor',
        'RO-BN' => 'Bistrița-Năsăud',
        'RO-BT' => 'Botoșani',
        'RO-BV' => 'Brașov',
        'RO-BR' => 'Brăila',
        'RO-B' => 'București',
        'RO-BZ' => 'Buzău',
        'RO-CS' => 'Caraș-Severin',
        'RO-CJ' => 'Cluj',
        'RO-CT' => 'Constanța',
        'RO-CV' => 'Covasna',
        'RO-CL' => 'Călărași',
        'RO-DJ' => 'Dolj',
        'RO-DB' => 'Dâmbovița',
        'RO-GL' => 'Galați',
        'RO-GR' => 'Giurgiu',
        'RO-GJ' => 'Gorj',
        'RO-HR' => 'Harghita',
        'RO-HD' => 'Hunedoara',
        'RO-IL' => 'Ialomița',
        'RO-IS' => 'Iași',
        'RO-IF' => 'Ilfov',
        'RO-MM' => 'Maramureș',
        'RO-MH' => 'Mehedinți',
        'RO-MS' => 'Mureș',
        'RO-NT' => 'Neamț',
        'RO-OT' => 'Olt',
        'RO-PH' => 'Prahova',
        'RO-SM' => 'Satu Mare',
        'RO-SB' => 'Sibiu',
        'RO-SV' => 'Suceava',
        'RO-SJ' => 'Sălaj',
        'RO-TR' => 'Teleorman',
        'RO-TM' => 'Timiș',
        'RO-TL' => 'Tulcea',
        'RO-VS' => 'Vaslui',
        'RO-VN' => 'Vrancea',
        'RO-VL' => 'Vâlcea',
    ],
    'RS' => [
        'RS-00' => 'Beograd',
        'RS-14' => 'Borski okrug',
        'RS-11' => 'Braničevski okrug',
        'RS-23' => 'Jablanički okrug',
        'RS-09' => 'Kolubarski okrug',
        'RS-KM' => 'Kosovo-Metohija',
        'RS-08' => 'Mačvanski okrug',
        'RS-17' => 'Moravički okrug',
        'RS-20' => 'Nišavski okrug',
        'RS-22' => 'Pirotski okrug',
        'RS-10' => 'Podunavski okrug',
        'RS-13' => 'Pomoravski okrug',
        'RS-24' => 'Pčinjski okrug',
        'RS-19' => 'Rasinski okrug',
        'RS-18' => 'Raški okrug',
        'RS-21' => 'Toplički okrug',
        'RS-VO' => 'Vojvodina',
        'RS-15' => 'Zaječarski okrug',
        'RS-16' => 'Zlatiborski okrug',
        'RS-12' => 'Šumadijski okrug',
    ],
    'RU' => [
        'RU-AD' => 'Adygeya, Respublika',
        'RU-AL' => 'Altay, Respublika',
        'RU-ALT' => 'Altayskiy kray',
        'RU-AMU' => 'Amurskaya oblast\'',
        'RU-ARK' => 'Arkhangel\'skaya oblast\'',
        'RU-AST' => 'Astrakhanskaya oblast\'',
        'RU-BA' => 'Baškortostan, Respublika',
        'RU-BEL' => 'Belgorodskaya oblast\'',
        'RU-BRY' => 'Bryanskaya oblast\'',
        'RU-BU' => 'Buryatiya, Respublika',
        'RU-CE' => 'Čečenskaja Respublika',
        'RU-CHE' => 'Čeljabinskaja oblast\'',
        'RU-CHU' => 'Čukotskij avtonomnyj okrug',
        'RU-CU' => 'Čuvašskaja Respublika',
        'RU-DA' => 'Dagestan, Respublika',
        'RU-YEV' => 'Yevreyskaya avtonomnaya oblast\'',
        'RU-KHA' => 'Khabarovskiy kray',
        'RU-KK' => 'Khakasiya, Respublika',
        'RU-KHM' => 'Khanty-Mansiyskiy avtonomnyy okrug',
        'RU-IN' => 'Ingušetija, Respublika',
        'RU-IRK' => 'Irkutskaya oblast\'',
        'RU-IVA' => 'Ivanovskaya oblast\'',
        'RU-YAN' => 'Yamalo-Nenetskiy avtonomnyy okrug',
        'RU-YAR' => 'Yaroslavskaya oblast\'',
        'RU-KB' => 'Kabardino-Balkarskaya Respublika',
        'RU-KGD' => 'Kaliningradskaya oblast\'',
        'RU-KL' => 'Kalmykiya, Respublika',
        'RU-KLU' => 'Kalužskaja oblast\'',
        'RU-KAM' => 'Kamčatskij kraj',
        'RU-KC' => 'Karačaevo-Čerkesskaja Respublika',
        'RU-KR' => 'Kareliya, Respublika',
        'RU-KEM' => 'Kemerovskaya oblast\'',
        'RU-KIR' => 'Kirovskaya oblast\'',
        'RU-KO' => 'Komi, Respublika',
        'RU-KOS' => 'Kostromskaya oblast\'',
        'RU-KDA' => 'Krasnodarskiy kray',
        'RU-KYA' => 'Krasnoyarskiy kray',
        'RU-KGN' => 'Kurganskaya oblast\'',
        'RU-KRS' => 'Kurskaya oblast\'',
        'RU-LEN' => 'Leningradskaya oblast\'',
        'RU-LIP' => 'Lipetskaya oblast\'',
        'RU-MAG' => 'Magadanskaya oblast\'',
        'RU-ME' => 'Mariy El, Respublika',
        'RU-MO' => 'Mordoviya, Respublika',
        'RU-MOS' => 'Moskovskaya oblast\'',
        'RU-MOW' => 'Moskva',
        'RU-MUR' => 'Murmanskaya oblast\'',
        'RU-NEN' => 'Nenetskiy avtonomnyy okrug',
        'RU-NIZ' => 'Nižegorodskaja oblast\'',
        'RU-NGR' => 'Novgorodskaya oblast\'',
        'RU-NVS' => 'Novosibirskaya oblast\'',
        'RU-OMS' => 'Omskaya oblast\'',
        'RU-ORE' => 'Orenburgskaya oblast\'',
        'RU-ORL' => 'Orlovskaya oblast\'',
        'RU-PNZ' => 'Penzenskaya oblast\'',
        'RU-PER' => 'Permskiy kray',
        'RU-PRI' => 'Primorskiy kray',
        'RU-PSK' => 'Pskovskaya oblast\'',
        'RU-RYA' => 'Ryazanskaya oblast\'',
        'RU-ROS' => 'Rostovskaya oblast\'',
        'RU-SA' => 'Sakha, Respublika',
        'RU-SAK' => 'Sakhalinskaya oblast\'',
        'RU-SAM' => 'Samarskaya oblast\'',
        'RU-SPE' => 'Sankt-Peterburg',
        'RU-SAR' => 'Saratovskaya oblast\'',
        'RU-SE' => 'Severnaya Osetiya, Respublika',
        'RU-SMO' => 'Smolenskaya oblast\'',
        'RU-STA' => 'Stavropol\'skiy kray',
        'RU-SVE' => 'Sverdlovskaya oblast\'',
        'RU-TAM' => 'Tambovskaya oblast\'',
        'RU-TA' => 'Tatarstan, Respublika',
        'RU-TYU' => 'Tyumenskaya oblast\'',
        'RU-TOM' => 'Tomskaya oblast\'',
        'RU-TUL' => 'Tul\'skaya oblast\'',
        'RU-TVE' => 'Tverskaya oblast\'',
        'RU-TY' => 'Tyva, Respublika',
        'RU-UD' => 'Udmurtskaya Respublika',
        'RU-ULY' => 'Ul\'yanovskaya oblast\'',
        'RU-VLA' => 'Vladimirskaya oblast\'',
        'RU-VGG' => 'Volgogradskaya oblast\'',
        'RU-VLG' => 'Vologodskaya oblast\'',
        'RU-VOR' => 'Voronežskaja oblast\'',
        'RU-ZAB' => 'Zabaykal\'skiy kray',
    ],
    'RW' => [
        'RW-01' => 'City of Kigali',
        'RW-02' => 'Eastern',
        'RW-03' => 'Northern',
        'RW-05' => 'Southern',
        'RW-04' => 'Western',
    ],
    'SA' => [
        'SA-14' => '\'Asīr',
        'SA-11' => 'Al Bāḩah',
        'SA-12' => 'Al Jawf',
        'SA-03' => 'Al Madīnah al Munawwarah',
        'SA-05' => 'Al Qaşīm',
        'SA-08' => 'Al Ḩudūd ash Shamālīyah',
        'SA-01' => 'Ar Riyāḑ',
        'SA-04' => 'Ash Sharqīyah',
        'SA-09' => 'Jāzān',
        'SA-02' => 'Makkah al Mukarramah',
        'SA-10' => 'Najrān',
        'SA-07' => 'Tabūk',
        'SA-06' => 'Ḩā\'il',
    ],
    'SB' => [
        'SB-CT' => 'Capital Territory (Honiara)',
        'SB-CE' => 'Central',
        'SB-CH' => 'Choiseul',
        'SB-GU' => 'Guadalcanal',
        'SB-IS' => 'Isabel',
        'SB-MK' => 'Makira-Ulawa',
        'SB-ML' => 'Malaita',
        'SB-RB' => 'Rennell and Bellona',
        'SB-TE' => 'Temotu',
        'SB-WE' => 'Western',
    ],
    'SC' => [
        'SC-02' => 'Anse Boileau',
        'SC-03' => 'Anse Etoile',
        'SC-05' => 'Anse Royale',
        'SC-01' => 'Anse aux Pins',
        'SC-04' => 'Au Cap',
        'SC-06' => 'Baie Lazare',
        'SC-07' => 'Baie Sainte Anne',
        'SC-08' => 'Beau Vallon',
        'SC-09' => 'Bel Air',
        'SC-10' => 'Bel Ombre',
        'SC-11' => 'Cascade',
        'SC-16' => 'English River',
        'SC-12' => 'Glacis',
        'SC-13' => 'Grand Anse Mahe',
        'SC-14' => 'Grand Anse Praslin',
        'SC-15' => 'La Digue',
        'SC-24' => 'Les Mamelles',
        'SC-17' => 'Mont Buxton',
        'SC-18' => 'Mont Fleuri',
        'SC-19' => 'Plaisance',
        'SC-20' => 'Pointe Larue',
        'SC-21' => 'Port Glaud',
        'SC-25' => 'Roche Caiman',
        'SC-22' => 'Saint Louis',
        'SC-23' => 'Takamaka',
    ],
    'SD' => [
        'SD-RS' => 'Al Baḩr al Aḩmar',
        'SD-GZ' => 'Al Jazīrah',
        'SD-KH' => 'Al Kharţūm',
        'SD-GD' => 'Al Qaḑārif',
        'SD-NW' => 'An Nīl al Abyaḑ',
        'SD-NB' => 'An Nīl al Azraq',
        'SD-NO' => 'Ash Shamālīyah',
        'SD-DW' => 'Gharb Dārfūr',
        'SD-GK' => 'Gharb Kurdufān',
        'SD-DS' => 'Janūb Dārfūr',
        'SD-KS' => 'Janūb Kurdufān',
        'SD-KA' => 'Kassalā',
        'SD-NR' => 'Nahr an Nīl',
        'SD-DN' => 'Shamāl Dārfūr',
        'SD-DE' => 'Sharq Dārfūr',
        'SD-KN' => 'Shiamāl Kurdufān',
        'SD-SI' => 'Sinnār',
        'SD-DC' => 'Wasaţ Dārfūr Zālinjay',
    ],
    'SE' => [
        'SE-K' => 'Blekinge län [SE-10]',
        'SE-W' => 'Dalarnas län [SE-20]',
        'SE-I' => 'Gotlands län [SE-09]',
        'SE-X' => 'Gävleborgs län [SE-21]',
        'SE-N' => 'Hallands län [SE-13]',
        'SE-Z' => 'Jämtlands län [SE-23]',
        'SE-F' => 'Jönköpings län [SE-06]',
        'SE-H' => 'Kalmar län [SE-08]',
        'SE-G' => 'Kronobergs län [SE-07]',
        'SE-BD' => 'Norrbottens län [SE-25]',
        'SE-M' => 'Skåne län [SE-12]',
        'SE-AB' => 'Stockholms län [SE-01]',
        'SE-D' => 'Södermanlands län [SE-04]',
        'SE-C' => 'Uppsala län [SE-03]',
        'SE-S' => 'Värmlands län [SE-17]',
        'SE-AC' => 'Västerbottens län [SE-24]',
        'SE-Y' => 'Västernorrlands län [SE-22]',
        'SE-U' => 'Västmanlands län [SE-19]',
        'SE-O' => 'Västra Götalands län [SE-14]',
        'SE-T' => 'Örebro län [SE-18]',
        'SE-E' => 'Östergötlands län [SE-05]',
    ],
    'SG' => [
        'SG-01' => 'Central Singapore',
        'SG-02' => 'North East',
        'SG-03' => 'North West',
        'SG-04' => 'South East',
        'SG-05' => 'South West',
    ],
    'SH' => [
        'SH-AC' => 'Ascension',
        'SH-HL' => 'Saint Helena',
        'SH-TA' => 'Tristan da Cunha',
    ],
    'SI' => [
        'SI-001' => 'Ajdovščina',
        'SI-213' => 'Ankaran',
        'SI-195' => 'Apače',
        'SI-002' => 'Beltinci',
        'SI-148' => 'Benedikt',
        'SI-149' => 'Bistrica ob Sotli',
        'SI-003' => 'Bled',
        'SI-150' => 'Bloke',
        'SI-004' => 'Bohinj',
        'SI-005' => 'Borovnica',
        'SI-006' => 'Bovec',
        'SI-151' => 'Braslovče',
        'SI-007' => 'Brda',
        'SI-008' => 'Brezovica',
        'SI-009' => 'Brežice',
        'SI-152' => 'Cankova',
        'SI-011' => 'Celje',
        'SI-012' => 'Cerklje na Gorenjskem',
        'SI-013' => 'Cerknica',
        'SI-014' => 'Cerkno',
        'SI-153' => 'Cerkvenjak',
        'SI-196' => 'Cirkulane',
        'SI-018' => 'Destrnik',
        'SI-019' => 'Divača',
        'SI-154' => 'Dobje',
        'SI-020' => 'Dobrepolje',
        'SI-155' => 'Dobrna',
        'SI-021' => 'Dobrova-Polhov Gradec',
        'SI-156' => 'Dobrovnik',
        'SI-022' => 'Dol pri Ljubljani',
        'SI-157' => 'Dolenjske Toplice',
        'SI-023' => 'Domžale',
        'SI-024' => 'Dornava',
        'SI-025' => 'Dravograd',
        'SI-026' => 'Duplek',
        'SI-027' => 'Gorenja vas-Poljane',
        'SI-028' => 'Gorišnica',
        'SI-207' => 'Gorje',
        'SI-029' => 'Gornja Radgona',
        'SI-030' => 'Gornji Grad',
        'SI-031' => 'Gornji Petrovci',
        'SI-158' => 'Grad',
        'SI-032' => 'Grosuplje',
        'SI-159' => 'Hajdina',
        'SI-161' => 'Hodoš',
        'SI-162' => 'Horjul',
        'SI-160' => 'Hoče-Slivnica',
        'SI-034' => 'Hrastnik',
        'SI-035' => 'Hrpelje-Kozina',
        'SI-036' => 'Idrija',
        'SI-037' => 'Ig',
        'SI-038' => 'Ilirska Bistrica',
        'SI-039' => 'Ivančna Gorica',
        'SI-040' => 'Izola',
        'SI-041' => 'Jesenice',
        'SI-163' => 'Jezersko',
        'SI-042' => 'Juršinci',
        'SI-043' => 'Kamnik',
        'SI-044' => 'Kanal',
        'SI-045' => 'Kidričevo',
        'SI-046' => 'Kobarid',
        'SI-047' => 'Kobilje',
        'SI-049' => 'Komen',
        'SI-164' => 'Komenda',
        'SI-050' => 'Koper',
        'SI-197' => 'Kosanjevica na Krki',
        'SI-165' => 'Kostel',
        'SI-051' => 'Kozje',
        'SI-048' => 'Kočevje',
        'SI-052' => 'Kranj',
        'SI-053' => 'Kranjska Gora',
        'SI-166' => 'Križevci',
        'SI-054' => 'Krško',
        'SI-055' => 'Kungota',
        'SI-056' => 'Kuzma',
        'SI-057' => 'Laško',
        'SI-058' => 'Lenart',
        'SI-059' => 'Lendava',
        'SI-060' => 'Litija',
        'SI-061' => 'Ljubljana',
        'SI-062' => 'Ljubno',
        'SI-063' => 'Ljutomer',
        'SI-208' => 'Log-Dragomer',
        'SI-064' => 'Logatec',
        'SI-167' => 'Lovrenc na Pohorju',
        'SI-065' => 'Loška Dolina',
        'SI-066' => 'Loški Potok',
        'SI-068' => 'Lukovica',
        'SI-067' => 'Luče',
        'SI-069' => 'Majšperk',
        'SI-198' => 'Makole',
        'SI-070' => 'Maribor',
        'SI-168' => 'Markovci',
        'SI-071' => 'Medvode',
        'SI-072' => 'Mengeš',
        'SI-073' => 'Metlika',
        'SI-074' => 'Mežica',
        'SI-169' => 'Miklavž na Dravskem Polju',
        'SI-075' => 'Miren-Kostanjevica',
        'SI-212' => 'Mirna',
        'SI-170' => 'Mirna Peč',
        'SI-076' => 'Mislinja',
        'SI-199' => 'Mokronog-Trebelno',
        'SI-078' => 'Moravske Toplice',
        'SI-077' => 'Moravče',
        'SI-079' => 'Mozirje',
        'SI-080' => 'Murska Sobota',
        'SI-081' => 'Muta',
        'SI-082' => 'Naklo',
        'SI-083' => 'Nazarje',
        'SI-084' => 'Nova Gorica',
        'SI-085' => 'Novo Mesto',
        'SI-086' => 'Odranci',
        'SI-171' => 'Oplotnica',
        'SI-087' => 'Ormož',
        'SI-088' => 'Osilnica',
        'SI-089' => 'Pesnica',
        'SI-090' => 'Piran',
        'SI-091' => 'Pivka',
        'SI-172' => 'Podlehnik',
        'SI-093' => 'Podvelka',
        'SI-092' => 'Podčetrtek',
        'SI-200' => 'Poljčane',
        'SI-173' => 'Polzela',
        'SI-094' => 'Postojna',
        'SI-174' => 'Prebold',
        'SI-095' => 'Preddvor',
        'SI-175' => 'Prevalje',
        'SI-096' => 'Ptuj',
        'SI-097' => 'Puconci',
        'SI-100' => 'Radenci',
        'SI-099' => 'Radeče',
        'SI-101' => 'Radlje ob Dravi',
        'SI-102' => 'Radovljica',
        'SI-103' => 'Ravne na Koroškem',
        'SI-176' => 'Razkrižje',
        'SI-098' => 'Rače-Fram',
        'SI-201' => 'Renče-Vogrsko',
        'SI-209' => 'Rečica ob Savinji',
        'SI-104' => 'Ribnica',
        'SI-177' => 'Ribnica na Pohorju',
        'SI-107' => 'Rogatec',
        'SI-106' => 'Rogaška Slatina',
        'SI-105' => 'Rogašovci',
        'SI-108' => 'Ruše',
        'SI-178' => 'Selnica ob Dravi',
        'SI-109' => 'Semič',
        'SI-110' => 'Sevnica',
        'SI-111' => 'Sežana',
        'SI-112' => 'Slovenj Gradec',
        'SI-113' => 'Slovenska Bistrica',
        'SI-114' => 'Slovenske Konjice',
        'SI-179' => 'Sodražica',
        'SI-180' => 'Solčava',
        'SI-202' => 'Središče ob Dravi',
        'SI-115' => 'Starše',
        'SI-203' => 'Straža',
        'SI-181' => 'Sveta Ana',
        'SI-204' => 'Sveta Trojica v Slovenskih Goricah',
        'SI-182' => 'Sveti Andraž v Slovenskih Goricah',
        'SI-116' => 'Sveti Jurij',
        'SI-210' => 'Sveti Jurij v Slovenskih Goricah',
        'SI-205' => 'Sveti Tomaž',
        'SI-184' => 'Tabor',
        'SI-010' => 'Tišina',
        'SI-128' => 'Tolmin',
        'SI-129' => 'Trbovlje',
        'SI-130' => 'Trebnje',
        'SI-185' => 'Trnovska Vas',
        'SI-186' => 'Trzin',
        'SI-131' => 'Tržič',
        'SI-132' => 'Turnišče',
        'SI-133' => 'Velenje',
        'SI-187' => 'Velika Polana',
        'SI-134' => 'Velike Lašče',
        'SI-188' => 'Veržej',
        'SI-135' => 'Videm',
        'SI-136' => 'Vipava',
        'SI-137' => 'Vitanje',
        'SI-138' => 'Vodice',
        'SI-139' => 'Vojnik',
        'SI-189' => 'Vransko',
        'SI-140' => 'Vrhnika',
        'SI-141' => 'Vuzenica',
        'SI-142' => 'Zagorje ob Savi',
        'SI-143' => 'Zavrč',
        'SI-144' => 'Zreče',
        'SI-015' => 'Črenšovci',
        'SI-016' => 'Črna na Koroškem',
        'SI-017' => 'Črnomelj',
        'SI-033' => 'Šalovci',
        'SI-183' => 'Šempeter-Vrtojba',
        'SI-118' => 'Šentilj',
        'SI-119' => 'Šentjernej',
        'SI-120' => 'Šentjur',
        'SI-211' => 'Šentrupert',
        'SI-117' => 'Šenčur',
        'SI-121' => 'Škocjan',
        'SI-122' => 'Škofja Loka',
        'SI-123' => 'Škofljica',
        'SI-124' => 'Šmarje pri Jelšah',
        'SI-206' => 'Šmarješke Toplice',
        'SI-125' => 'Šmartno ob Paki',
        'SI-194' => 'Šmartno pri Litiji',
        'SI-126' => 'Šoštanj',
        'SI-127' => 'Štore',
        'SI-190' => 'Žalec',
        'SI-146' => 'Železniki',
        'SI-191' => 'Žetale',
        'SI-147' => 'Žiri',
        'SI-192' => 'Žirovnica',
        'SI-193' => 'Žužemberk',
    ],
    'SK' => [
        'SK-BC' => 'Banskobystrický kraj',
        'SK-BL' => 'Bratislavský kraj',
        'SK-KI' => 'Košický kraj',
        'SK-NI' => 'Nitriansky kraj',
        'SK-PV' => 'Prešovský kraj',
        'SK-TC' => 'Trenčiansky kraj',
        'SK-TA' => 'Trnavský kraj',
        'SK-ZI' => 'Žilinský kraj',
    ],
    'SL' => [
        'SL-E' => 'Eastern',
        'SL-N' => 'Northern',
        'SL-S' => 'Southern',
        'SL-W' => 'Western Area (Freetown)',
    ],
    'SM' => [
        'SM-01' => 'Acquaviva',
        'SM-06' => 'Borgo Maggiore',
        'SM-02' => 'Chiesanuova',
        'SM-03' => 'Domagnano',
        'SM-04' => 'Faetano',
        'SM-05' => 'Fiorentino',
        'SM-08' => 'Montegiardino',
        'SM-07' => 'San Marino',
        'SM-09' => 'Serravalle',
    ],
    'SN' => [
        'SN-DK' => 'Dakar',
        'SN-DB' => 'Diourbel',
        'SN-FK' => 'Fatick',
        'SN-KA' => 'Kaffrine',
        'SN-KL' => 'Kaolack',
        'SN-KD' => 'Kolda',
        'SN-KE' => 'Kédougou',
        'SN-LG' => 'Louga',
        'SN-MT' => 'Matam',
        'SN-SL' => 'Saint-Louis',
        'SN-SE' => 'Sédhiou',
        'SN-TC' => 'Tambacounda',
        'SN-TH' => 'Thiès',
        'SN-ZG' => 'Ziguinchor',
    ],
    'SO' => [
        'SO-AW' => 'Awdal',
        'SO-BK' => 'Bakool',
        'SO-BN' => 'Banaadir',
        'SO-BR' => 'Bari',
        'SO-BY' => 'Bay',
        'SO-GA' => 'Galguduud',
        'SO-GE' => 'Gedo',
        'SO-HI' => 'Hiiraan',
        'SO-JD' => 'Jubbada Dhexe',
        'SO-JH' => 'Jubbada Hoose',
        'SO-MU' => 'Mudug',
        'SO-NU' => 'Nugaal',
        'SO-SA' => 'Sanaag',
        'SO-SD' => 'Shabeellaha Dhexe',
        'SO-SH' => 'Shabeellaha Hoose',
        'SO-SO' => 'Sool',
        'SO-TO' => 'Togdheer',
        'SO-WO' => 'Woqooyi Galbeed',
    ],
    'SR' => [
        'SR-BR' => 'Brokopondo',
        'SR-CM' => 'Commewijne',
        'SR-CR' => 'Coronie',
        'SR-MA' => 'Marowijne',
        'SR-NI' => 'Nickerie',
        'SR-PR' => 'Para',
        'SR-PM' => 'Paramaribo',
        'SR-SA' => 'Saramacca',
        'SR-SI' => 'Sipaliwini',
        'SR-WA' => 'Wanica',
    ],
    'SS' => [
        'SS-EC' => 'Central Equatoria',
        'SS-EE' => 'Eastern Equatoria',
        'SS-JG' => 'Jonglei',
        'SS-LK' => 'Lakes',
        'SS-BN' => 'Northern Bahr el Ghazal',
        'SS-UY' => 'Unity',
        'SS-NU' => 'Upper Nile',
        'SS-WR' => 'Warrap',
        'SS-BW' => 'Western Bahr el  Ghazal',
        'SS-EW' => 'Western Equatoria',
    ],
    'ST' => [
        'ST-P' => 'Príncipe',
        'ST-S' => 'São Tomé',
    ],
    'SV' => [
        'SV-AH' => 'Ahuachapán',
        'SV-CA' => 'Cabañas',
        'SV-CH' => 'Chalatenango',
        'SV-CU' => 'Cuscatlán',
        'SV-LI' => 'La Libertad',
        'SV-PA' => 'La Paz',
        'SV-UN' => 'La Unión',
        'SV-MO' => 'Morazán',
        'SV-SM' => 'San Miguel',
        'SV-SS' => 'San Salvador',
        'SV-SV' => 'San Vicente',
        'SV-SA' => 'Santa Ana',
        'SV-SO' => 'Sonsonate',
        'SV-US' => 'Usulután',
    ],
    'SY' => [
        'SY-LA' => 'Al Lādhiqīyah',
        'SY-QU' => 'Al Qunayţirah',
        'SY-HA' => 'Al Ḩasakah',
        'SY-RA' => 'Ar Raqqah',
        'SY-SU' => 'As Suwaydā\'',
        'SY-DR' => 'Dar\'ā',
        'SY-DY' => 'Dayr az Zawr',
        'SY-DI' => 'Dimashq',
        'SY-ID' => 'Idlib',
        'SY-RD' => 'Rīf Dimashq',
        'SY-TA' => 'Ţarţūs',
        'SY-HL' => 'Ḩalab',
        'SY-HM' => 'Ḩamāh',
        'SY-HI' => 'Ḩimş',
    ],
    'SZ' => [
        'SZ-HH' => 'Hhohho',
        'SZ-LU' => 'Lubombo',
        'SZ-MA' => 'Manzini',
        'SZ-SH' => 'Shiselweni',
    ],
    'TD' => [
        'TD-BA' => 'Al Baţḩah',
        'TD-LC' => 'Al Buḩayrah',
        'TD-BG' => 'Baḩr al Ghazāl',
        'TD-BO' => 'Būrkū',
        'TD-KA' => 'Kānim',
        'TD-LO' => 'Lūqūn al Gharbī',
        'TD-LR' => 'Lūqūn ash Sharqī',
        'TD-ND' => 'Madīnat Injamīnā',
        'TD-MA' => 'Māndūl',
        'TD-MO' => 'Māyū Kībbī al Gharbī',
        'TD-ME' => 'Māyū Kībbī ash Sharqī',
        'TD-GR' => 'Qīrā',
        'TD-SA' => 'Salāmāt',
        'TD-CB' => 'Shārī Bāqirmī',
        'TD-MC' => 'Shārī al Awsaţ',
        'TD-SI' => 'Sīlā',
        'TD-TI' => 'Tibastī',
        'TD-TA' => 'Tānjilī',
        'TD-OD' => 'Waddāy',
        'TD-WF' => 'Wādī Fīrā',
        'TD-HL' => 'Ḩajjar Lamīs',
        'TD-EE' => 'Ennedi-Est',
        'TD-EO' => 'Ennedi-Ouest',
    ],
    'TG' => [
        'TG-C' => 'Centrale',
        'TG-K' => 'Kara',
        'TG-M' => 'Maritime (Région)',
        'TG-P' => 'Plateaux',
        'TG-S' => 'Savanes',
    ],
    'TH' => [
        'TH-37' => 'Amnat Charoen',
        'TH-15' => 'Ang Thong',
        'TH-38' => 'Bueng Kan',
        'TH-31' => 'Buri Ram',
        'TH-24' => 'Chachoengsao',
        'TH-18' => 'Chai Nat',
        'TH-36' => 'Chaiyaphum',
        'TH-22' => 'Chanthaburi',
        'TH-50' => 'Chiang Mai',
        'TH-57' => 'Chiang Rai',
        'TH-20' => 'Chon Buri',
        'TH-86' => 'Chumphon',
        'TH-46' => 'Kalasin',
        'TH-62' => 'Kamphaeng Phet',
        'TH-71' => 'Kanchanaburi',
        'TH-40' => 'Khon Kaen',
        'TH-81' => 'Krabi',
        'TH-10' => 'Krung Thep Maha Nakhon',
        'TH-52' => 'Lampang',
        'TH-51' => 'Lamphun',
        'TH-42' => 'Loei',
        'TH-16' => 'Lop Buri',
        'TH-58' => 'Mae Hong Son',
        'TH-44' => 'Maha Sarakham',
        'TH-49' => 'Mukdahan',
        'TH-26' => 'Nakhon Nayok',
        'TH-73' => 'Nakhon Pathom',
        'TH-48' => 'Nakhon Phanom',
        'TH-30' => 'Nakhon Ratchasima',
        'TH-60' => 'Nakhon Sawan',
        'TH-80' => 'Nakhon Si Thammarat',
        'TH-55' => 'Nan',
        'TH-96' => 'Narathiwat',
        'TH-39' => 'Nong Bua Lam Phu',
        'TH-43' => 'Nong Khai',
        'TH-12' => 'Nonthaburi',
        'TH-13' => 'Pathum Thani',
        'TH-94' => 'Pattani',
        'TH-82' => 'Phangnga',
        'TH-93' => 'Phatthalung',
        'TH-S' => 'Phatthaya',
        'TH-56' => 'Phayao',
        'TH-67' => 'Phetchabun',
        'TH-76' => 'Phetchaburi',
        'TH-66' => 'Phichit',
        'TH-65' => 'Phitsanulok',
        'TH-14' => 'Phra Nakhon Si Ayutthaya',
        'TH-54' => 'Phrae',
        'TH-83' => 'Phuket',
        'TH-25' => 'Prachin Buri',
        'TH-77' => 'Prachuap Khiri Khan',
        'TH-85' => 'Ranong',
        'TH-70' => 'Ratchaburi',
        'TH-21' => 'Rayong',
        'TH-45' => 'Roi Et',
        'TH-27' => 'Sa Kaeo',
        'TH-47' => 'Sakon Nakhon',
        'TH-11' => 'Samut Prakan',
        'TH-74' => 'Samut Sakhon',
        'TH-75' => 'Samut Songkhram',
        'TH-19' => 'Saraburi',
        'TH-91' => 'Satun',
        'TH-33' => 'Si Sa Ket',
        'TH-17' => 'Sing Buri',
        'TH-90' => 'Songkhla',
        'TH-64' => 'Sukhothai',
        'TH-72' => 'Suphan Buri',
        'TH-84' => 'Surat Thani',
        'TH-32' => 'Surin',
        'TH-63' => 'Tak',
        'TH-92' => 'Trang',
        'TH-23' => 'Trat',
        'TH-34' => 'Ubon Ratchathani',
        'TH-41' => 'Udon Thani',
        'TH-61' => 'Uthai Thani',
        'TH-53' => 'Uttaradit',
        'TH-95' => 'Yala',
        'TH-35' => 'Yasothon',
    ],
    'TJ' => [
        'TJ-DU' => 'Dushanbe',
        'TJ-KT' => 'Khatlon',
        'TJ-GB' => 'Kŭhistoni Badakhshon',
        'TJ-SU' => 'Sughd',
        'TJ-RA' => 'nohiyahoi tobei jumhurí',
    ],
    'TL' => [
        'TL-AL' => 'Aileu',
        'TL-AN' => 'Ainaro',
        'TL-BA' => 'Baucau',
        'TL-BO' => 'Bobonaro',
        'TL-CO' => 'Cova Lima',
        'TL-DI' => 'Díli',
        'TL-ER' => 'Ermera',
        'TL-LA' => 'Lautem',
        'TL-LI' => 'Liquiça',
        'TL-MT' => 'Manatuto',
        'TL-MF' => 'Manufahi',
        'TL-OE' => 'Oecussi',
        'TL-VI' => 'Viqueque',
    ],
    'TM' => [
        'TM-A' => 'Ahal',
        'TM-S' => 'Aşgabat',
        'TM-B' => 'Balkan',
        'TM-D' => 'Daşoguz',
        'TM-L' => 'Lebap',
        'TM-M' => 'Mary',
    ],
    'TN' => [
        'TN-13' => 'Ben Arous',
        'TN-23' => 'Bizerte',
        'TN-31' => 'Béja',
        'TN-81' => 'Gabès',
        'TN-71' => 'Gafsa',
        'TN-32' => 'Jendouba',
        'TN-41' => 'Kairouan',
        'TN-42' => 'Kasserine',
        'TN-73' => 'Kébili',
        'TN-12' => 'L\'Ariana',
        'TN-14' => 'La Manouba',
        'TN-33' => 'Le Kef',
        'TN-53' => 'Mahdia',
        'TN-52' => 'Monastir',
        'TN-82' => 'Médenine',
        'TN-21' => 'Nabeul',
        'TN-61' => 'Sfax',
        'TN-43' => 'Sidi Bouzid',
        'TN-34' => 'Siliana',
        'TN-51' => 'Sousse',
        'TN-83' => 'Tataouine',
        'TN-72' => 'Tozeur',
        'TN-11' => 'Tunis',
        'TN-22' => 'Zaghouan',
    ],
    'TO' => [
        'TO-01' => '\'Eua',
        'TO-02' => 'Ha\'apai',
        'TO-03' => 'Niuas',
        'TO-04' => 'Tongatapu',
        'TO-05' => 'Vava\'u',
    ],
    'TR' => [
        'TR-01' => 'Adana',
        'TR-02' => 'Adıyaman',
        'TR-03' => 'Afyonkarahisar',
        'TR-68' => 'Aksaray',
        'TR-05' => 'Amasya',
        'TR-06' => 'Ankara',
        'TR-07' => 'Antalya',
        'TR-75' => 'Ardahan',
        'TR-08' => 'Artvin',
        'TR-09' => 'Aydın',
        'TR-04' => 'Ağrı',
        'TR-10' => 'Balıkesir',
        'TR-74' => 'Bartın',
        'TR-72' => 'Batman',
        'TR-69' => 'Bayburt',
        'TR-11' => 'Bilecik',
        'TR-12' => 'Bingöl',
        'TR-13' => 'Bitlis',
        'TR-14' => 'Bolu',
        'TR-15' => 'Burdur',
        'TR-16' => 'Bursa',
        'TR-20' => 'Denizli',
        'TR-21' => 'Diyarbakır',
        'TR-81' => 'Düzce',
        'TR-22' => 'Edirne',
        'TR-23' => 'Elazığ',
        'TR-24' => 'Erzincan',
        'TR-25' => 'Erzurum',
        'TR-26' => 'Eskişehir',
        'TR-27' => 'Gaziantep',
        'TR-28' => 'Giresun',
        'TR-29' => 'Gümüşhane',
        'TR-30' => 'Hakkâri',
        'TR-31' => 'Hatay',
        'TR-32' => 'Isparta',
        'TR-76' => 'Iğdır',
        'TR-46' => 'Kahramanmaraş',
        'TR-78' => 'Karabük',
        'TR-70' => 'Karaman',
        'TR-36' => 'Kars',
        'TR-37' => 'Kastamonu',
        'TR-38' => 'Kayseri',
        'TR-79' => 'Kilis',
        'TR-41' => 'Kocaeli',
        'TR-42' => 'Konya',
        'TR-43' => 'Kütahya',
        'TR-39' => 'Kırklareli',
        'TR-71' => 'Kırıkkale',
        'TR-40' => 'Kırşehir',
        'TR-44' => 'Malatya',
        'TR-45' => 'Manisa',
        'TR-47' => 'Mardin',
        'TR-33' => 'Mersin',
        'TR-48' => 'Muğla',
        'TR-49' => 'Muş',
        'TR-50' => 'Nevşehir',
        'TR-51' => 'Niğde',
        'TR-52' => 'Ordu',
        'TR-80' => 'Osmaniye',
        'TR-53' => 'Rize',
        'TR-54' => 'Sakarya',
        'TR-55' => 'Samsun',
        'TR-56' => 'Siirt',
        'TR-57' => 'Sinop',
        'TR-58' => 'Sivas',
        'TR-59' => 'Tekirdağ',
        'TR-60' => 'Tokat',
        'TR-61' => 'Trabzon',
        'TR-62' => 'Tunceli',
        'TR-64' => 'Uşak',
        'TR-65' => 'Van',
        'TR-77' => 'Yalova',
        'TR-66' => 'Yozgat',
        'TR-67' => 'Zonguldak',
        'TR-17' => 'Çanakkale',
        'TR-18' => 'Çankırı',
        'TR-19' => 'Çorum',
        'TR-34' => 'İstanbul',
        'TR-35' => 'İzmir',
        'TR-63' => 'Şanlıurfa',
        'TR-73' => 'Şırnak',
    ],
    'TT' => [
        'TT-ARI' => 'Arima',
        'TT-CHA' => 'Chaguanas',
        'TT-CTT' => 'Couva-Tabaquite-Talparo',
        'TT-DMN' => 'Diego Martin',
        'TT-MRC' => 'Mayaro-Rio Claro',
        'TT-PED' => 'Penal-Debe',
        'TT-PTF' => 'Point Fortin',
        'TT-POS' => 'Port of Spain',
        'TT-PRT' => 'Princes Town',
        'TT-SFO' => 'San Fernando',
        'TT-SJL' => 'San Juan-Laventille',
        'TT-SGE' => 'Sangre Grande',
        'TT-SIP' => 'Siparia',
        'TT-TOB' => 'Tobago',
        'TT-TUP' => 'Tunapuna-Piarco',
    ],
    'TV' => [
        'TV-FUN' => 'Funafuti',
        'TV-NMG' => 'Nanumaga',
        'TV-NMA' => 'Nanumea',
        'TV-NIT' => 'Niutao',
        'TV-NUI' => 'Nui',
        'TV-NKF' => 'Nukufetau',
        'TV-NKL' => 'Nukulaelae',
        'TV-VAI' => 'Vaitupu',
    ],
    'TW' => [
        'TW-CHA' => 'Changhua',
        'TW-CYI' => 'Chiayi',
        'TW-CYQ' => 'Chiayi',
        'TW-HSZ' => 'Hsinchu',
        'TW-HSQ' => 'Hsinchu',
        'TW-HUA' => 'Hualien',
        'TW-KHH' => 'Kaohsiung',
        'TW-KEE' => 'Keelung',
        'TW-KIN' => 'Kinmen',
        'TW-LIE' => 'Lienchiang',
        'TW-MIA' => 'Miaoli',
        'TW-NAN' => 'Nantou',
        'TW-NWT' => 'New Taipei',
        'TW-PEN' => 'Penghu',
        'TW-PIF' => 'Pingtung',
        'TW-TXG' => 'Taichung',
        'TW-TNN' => 'Tainan',
        'TW-TPE' => 'Taipei',
        'TW-TTT' => 'Taitung',
        'TW-TAO' => 'Taoyuan',
        'TW-ILA' => 'Yilan',
        'TW-YUN' => 'Yunlin',
    ],
    'TZ' => [
        'TZ-19' => 'Coast',
        'TZ-06' => 'Pemba North',
        'TZ-10' => 'Pemba South',
        'TZ-07' => 'Zanzibar North',
        'TZ-11' => 'Zanzibar South',
        'TZ-15' => 'Zanzibar West',
        'TZ-01' => 'Arusha',
        'TZ-02' => 'Dar es Salaam',
        'TZ-03' => 'Dodoma',
        'TZ-27' => 'Geita',
        'TZ-04' => 'Iringa',
        'TZ-05' => 'Kagera',
        'TZ-28' => 'Katavi',
        'TZ-08' => 'Kigoma',
        'TZ-09' => 'Kilimanjaro',
        'TZ-12' => 'Lindi',
        'TZ-26' => 'Manyara',
        'TZ-13' => 'Mara',
        'TZ-14' => 'Mbeya',
        'TZ-16' => 'Morogoro',
        'TZ-17' => 'Mtwara',
        'TZ-18' => 'Mwanza',
        'TZ-29' => 'Njombe',
        'TZ-20' => 'Rukwa',
        'TZ-21' => 'Ruvuma',
        'TZ-22' => 'Shinyanga',
        'TZ-30' => 'Simiyu',
        'TZ-23' => 'Singida',
        'TZ-24' => 'Tabora',
        'TZ-25' => 'Tanga',
    ],
    'UA' => [
        'UA-43' => 'Avtonomna Respublika Krym',
        'UA-71' => 'Cherkaska oblast',
        'UA-74' => 'Chernihivska oblast',
        'UA-77' => 'Chernivetska oblast',
        'UA-12' => 'Dnipropetrovska oblast',
        'UA-14' => 'Donetska oblast',
        'UA-26' => 'Ivano-Frankivska oblast',
        'UA-63' => 'Kharkivska oblast',
        'UA-65' => 'Khersonska oblast',
        'UA-68' => 'Khmelnytska oblast',
        'UA-35' => 'Kirovohradska oblast',
        'UA-30' => 'Kyiv',
        'UA-32' => 'Kyivska oblast',
        'UA-09' => 'Luhanska oblast',
        'UA-46' => 'Lvivska oblast',
        'UA-48' => 'Mykolaivska oblast',
        'UA-51' => 'Odeska oblast',
        'UA-53' => 'Poltavska oblast',
        'UA-56' => 'Rivnenska oblast',
        'UA-40' => 'Sevastopol',
        'UA-59' => 'Sumska oblast',
        'UA-61' => 'Ternopilska oblast',
        'UA-05' => 'Vinnytska oblast',
        'UA-07' => 'Volynska oblast',
        'UA-21' => 'Zakarpatska oblast',
        'UA-23' => 'Zaporizka oblast',
        'UA-18' => 'Zhytomyrska oblast',
    ],
    'UG' => [
        'UG-C' => 'Central',
        'UG-E' => 'Eastern',
        'UG-N' => 'Northern',
        'UG-W' => 'Western',
    ],
    'UM' => [
        'UM-81' => 'Baker Island',
        'UM-84' => 'Howland Island',
        'UM-86' => 'Jarvis Island',
        'UM-67' => 'Johnston Atoll',
        'UM-89' => 'Kingman Reef',
        'UM-71' => 'Midway Islands',
        'UM-76' => 'Navassa Island',
        'UM-95' => 'Palmyra Atoll',
        'UM-79' => 'Wake Island',
    ],
    'US' => [
        'US-AL' => 'Alabama',
        'US-AK' => 'Alaska',
        'US-AS' => 'American Samoa (see also separate country code entry under AS)',
        'US-AZ' => 'Arizona',
        'US-AR' => 'Arkansas',
        'US-CA' => 'California',
        'US-CO' => 'Colorado',
        'US-CT' => 'Connecticut',
        'US-DE' => 'Delaware',
        'US-DC' => 'District of Columbia',
        'US-FL' => 'Florida',
        'US-GA' => 'Georgia',
        'US-GU' => 'Guam (see also separate country code entry under GU)',
        'US-HI' => 'Hawaii',
        'US-ID' => 'Idaho',
        'US-IL' => 'Illinois',
        'US-IN' => 'Indiana',
        'US-IA' => 'Iowa',
        'US-KS' => 'Kansas',
        'US-KY' => 'Kentucky',
        'US-LA' => 'Louisiana',
        'US-ME' => 'Maine',
        'US-MD' => 'Maryland',
        'US-MA' => 'Massachusetts',
        'US-MI' => 'Michigan',
        'US-MN' => 'Minnesota',
        'US-MS' => 'Mississippi',
        'US-MO' => 'Missouri',
        'US-MT' => 'Montana',
        'US-NE' => 'Nebraska',
        'US-NV' => 'Nevada',
        'US-NH' => 'New Hampshire',
        'US-NJ' => 'New Jersey',
        'US-NM' => 'New Mexico',
        'US-NY' => 'New York',
        'US-NC' => 'North Carolina',
        'US-ND' => 'North Dakota',
        'US-MP' => 'Northern Mariana Islands (see also separate country code entry under MP)',
        'US-OH' => 'Ohio',
        'US-OK' => 'Oklahoma',
        'US-OR' => 'Oregon',
        'US-PA' => 'Pennsylvania',
        'US-PR' => 'Puerto Rico (see also separate country code entry under PR)',
        'US-RI' => 'Rhode Island',
        'US-SC' => 'South Carolina',
        'US-SD' => 'South Dakota',
        'US-TN' => 'Tennessee',
        'US-TX' => 'Texas',
        'US-UM' => 'United States Minor Outlying Islands (see also separate country code entry under UM)',
        'US-UT' => 'Utah',
        'US-VT' => 'Vermont',
        'US-VI' => 'Virgin Islands, U.S. (see also separate country code entry under VI)',
        'US-VA' => 'Virginia',
        'US-WA' => 'Washington',
        'US-WV' => 'West Virginia',
        'US-WI' => 'Wisconsin',
        'US-WY' => 'Wyoming',
    ],
    'UY' => [
        'UY-AR' => 'Artigas',
        'UY-CA' => 'Canelones',
        'UY-CL' => 'Cerro Largo',
        'UY-CO' => 'Colonia',
        'UY-DU' => 'Durazno',
        'UY-FS' => 'Flores',
        'UY-FD' => 'Florida',
        'UY-LA' => 'Lavalleja',
        'UY-MA' => 'Maldonado',
        'UY-MO' => 'Montevideo',
        'UY-PA' => 'Paysandú',
        'UY-RV' => 'Rivera',
        'UY-RO' => 'Rocha',
        'UY-RN' => 'Río Negro',
        'UY-SA' => 'Salto',
        'UY-SJ' => 'San José',
        'UY-SO' => 'Soriano',
        'UY-TA' => 'Tacuarembó',
        'UY-TT' => 'Treinta y Tres',
    ],
    'UZ' => [
        'UZ-AN' => 'Andijon',
        'UZ-BU' => 'Buxoro',
        'UZ-FA' => 'Farg‘ona',
        'UZ-JI' => 'Jizzax',
        'UZ-NG' => 'Namangan',
        'UZ-NW' => 'Navoiy',
        'UZ-QA' => 'Qashqadaryo',
        'UZ-QR' => 'Qoraqalpog‘iston Respublikasi',
        'UZ-SA' => 'Samarqand',
        'UZ-SI' => 'Sirdaryo',
        'UZ-SU' => 'Surxondaryo',
        'UZ-TK' => 'Toshkent',
        'UZ-TO' => 'Toshkent',
        'UZ-XO' => 'Xorazm',
    ],
    'VC' => [
        'VC-01' => 'Charlotte',
        'VC-06' => 'Grenadines',
        'VC-02' => 'Saint Andrew',
        'VC-03' => 'Saint David',
        'VC-04' => 'Saint George',
        'VC-05' => 'Saint Patrick',
    ],
    'VE' => [
        'VE-Z' => 'Amazonas',
        'VE-B' => 'Anzoátegui',
        'VE-C' => 'Apure',
        'VE-D' => 'Aragua',
        'VE-E' => 'Barinas',
        'VE-F' => 'Bolívar',
        'VE-G' => 'Carabobo',
        'VE-H' => 'Cojedes',
        'VE-Y' => 'Delta Amacuro',
        'VE-W' => 'Dependencias Federales',
        'VE-A' => 'Distrito Capital',
        'VE-I' => 'Falcón',
        'VE-J' => 'Guárico',
        'VE-K' => 'Lara',
        'VE-M' => 'Miranda',
        'VE-N' => 'Monagas',
        'VE-L' => 'Mérida',
        'VE-O' => 'Nueva Esparta',
        'VE-P' => 'Portuguesa',
        'VE-R' => 'Sucre',
        'VE-T' => 'Trujillo',
        'VE-S' => 'Táchira',
        'VE-X' => 'Vargas',
        'VE-U' => 'Yaracuy',
        'VE-V' => 'Zulia',
    ],
    'VN' => [
        'VN-44' => 'An Giang',
        'VN-43' => 'Bà Rịa - Vũng Tàu',
        'VN-57' => 'Bình Dương',
        'VN-58' => 'Bình Phước',
        'VN-40' => 'Bình Thuận',
        'VN-31' => 'Bình Định',
        'VN-55' => 'Bạc Liêu',
        'VN-54' => 'Bắc Giang',
        'VN-53' => 'Bắc Kạn',
        'VN-56' => 'Bắc Ninh',
        'VN-50' => 'Bến Tre',
        'VN-CT' => 'Can Tho',
        'VN-04' => 'Cao Bằng',
        'VN-59' => 'Cà Mau',
        'VN-DN' => 'Da Nang',
        'VN-30' => 'Gia Lai',
        'VN-HN' => 'Ha Noi',
        'VN-HP' => 'Hai Phong',
        'VN-SG' => 'Ho Chi Minh',
        'VN-03' => 'Hà Giang',
        'VN-63' => 'Hà Nam',
        'VN-23' => 'Hà Tĩnh',
        'VN-14' => 'Hòa Bình',
        'VN-66' => 'Hưng Yên',
        'VN-61' => 'Hải Dương',
        'VN-73' => 'Hậu Giang',
        'VN-34' => 'Khánh Hòa',
        'VN-47' => 'Kiến Giang',
        'VN-28' => 'Kon Tum',
        'VN-01' => 'Lai Châu',
        'VN-41' => 'Long An',
        'VN-02' => 'Lào Cai',
        'VN-35' => 'Lâm Đồng',
        'VN-09' => 'Lạng Sơn',
        'VN-67' => 'Nam Định',
        'VN-22' => 'Nghệ An',
        'VN-18' => 'Ninh Bình',
        'VN-36' => 'Ninh Thuận',
        'VN-68' => 'Phú Thọ',
        'VN-32' => 'Phú Yên',
        'VN-24' => 'Quảng Bình',
        'VN-27' => 'Quảng Nam',
        'VN-29' => 'Quảng Ngãi',
        'VN-13' => 'Quảng Ninh',
        'VN-25' => 'Quảng Trị',
        'VN-52' => 'Sóc Trăng',
        'VN-05' => 'Sơn La',
        'VN-21' => 'Thanh Hóa',
        'VN-20' => 'Thái Bình',
        'VN-69' => 'Thái Nguyên',
        'VN-26' => 'Thừa Thiên-Huế',
        'VN-46' => 'Tiền Giang',
        'VN-51' => 'Trà Vinh',
        'VN-07' => 'Tuyên Quang',
        'VN-37' => 'Tây Ninh',
        'VN-49' => 'Vĩnh Long',
        'VN-70' => 'Vĩnh Phúc',
        'VN-06' => 'Yên Bái',
        'VN-71' => 'Điện Biên',
        'VN-33' => 'Đắk Lắk',
        'VN-72' => 'Đắk Nông',
        'VN-39' => 'Đồng Nai',
        'VN-45' => 'Đồng Tháp',
    ],
    'VU' => [
        'VU-MAP' => 'Malampa',
        'VU-PAM' => 'Pénama',
        'VU-SAM' => 'Sanma',
        'VU-SEE' => 'Shéfa',
        'VU-TAE' => 'Taféa',
        'VU-TOB' => 'Torba',
    ],
    'WF' => [
        'WF-AL' => 'Alo',
        'WF-SG' => 'Sigave',
        'WF-UV' => 'Uvea',
    ],
    'WS' => [
        'WS-AA' => 'A\'ana',
        'WS-AL' => 'Aiga-i-le-Tai',
        'WS-AT' => 'Atua',
        'WS-FA' => 'Fa\'asaleleaga',
        'WS-GE' => 'Gaga\'emauga',
        'WS-GI' => 'Gagaifomauga',
        'WS-PA' => 'Palauli',
        'WS-SA' => 'Satupa\'itea',
        'WS-TU' => 'Tuamasaga',
        'WS-VF' => 'Va\'a-o-Fonoti',
        'WS-VS' => 'Vaisigano',
    ],
    'YE' => [
        'YE-AB' => 'Abyan',
        'YE-BA' => 'Al Bayḑā’',
        'YE-JA' => 'Al Jawf',
        'YE-MR' => 'Al Mahrah',
        'YE-MW' => 'Al Maḩwīt',
        'YE-HU' => 'Al Ḩudaydah',
        'YE-SA' => 'Amānat al ‘Āşimah [city]',
        'YE-SU' => 'Arkhabīl Suquţrá',
        'YE-DA' => 'Aḑ Ḑāli‘',
        'YE-DH' => 'Dhamār',
        'YE-IB' => 'Ibb',
        'YE-LA' => 'Laḩij',
        'YE-MA' => 'Ma’rib',
        'YE-RA' => 'Raymah',
        'YE-SH' => 'Shabwah',
        'YE-TA' => 'Tāʻizz',
        'YE-SN' => 'Şanʻā’',
        'YE-SD' => 'Şāʻdah',
        'YE-HJ' => 'Ḩajjah',
        'YE-HD' => 'Ḩaḑramawt',
        'YE-AD' => '‘Adan',
        'YE-AM' => '‘Amrān',
    ],
    'ZA' => [
        'ZA-GP' => 'Gauteng',
        'ZA-KZN' => 'KwaZulu-Natal',
        'ZA-LP' => 'Limpopo',
        'ZA-MP' => 'Mpumalanga',
        'ZA-NC' => 'Noord-Kaap',
        'ZA-NW' => 'Noordwes',
        'ZA-EC' => 'Oos-Kaap',
        'ZA-FS' => 'Vrystaat',
        'ZA-WC' => 'Wes-Kaap',
    ],
    'ZM' => [
        'ZM-02' => 'Central',
        'ZM-08' => 'Copperbelt',
        'ZM-03' => 'Eastern',
        'ZM-04' => 'Luapula',
        'ZM-09' => 'Lusaka',
        'ZM-10' => 'Muchinga',
        'ZM-06' => 'North-Western',
        'ZM-05' => 'Northern',
        'ZM-07' => 'Southern',
        'ZM-01' => 'Western',
    ],
    'ZW' => [
        'ZW-BU' => 'Bulawayo',
        'ZW-HA' => 'Harare',
        'ZW-MA' => 'Manicaland',
        'ZW-MC' => 'Mashonaland Central',
        'ZW-ME' => 'Mashonaland East',
        'ZW-MW' => 'Mashonaland West',
        'ZW-MV' => 'Masvingo',
        'ZW-MN' => 'Matabeleland North',
        'ZW-MS' => 'Matabeleland South',
        'ZW-MI' => 'Midlands',
    ],
];
