<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage InvocationTags
 * @author     Radek Maciaszek <radek@m3.net>
 *
 */

require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_siteskinasync extends Plugins_InvocationTags
{

    /**
     * Return name of plugin
     *
     * @return string
     */
    function getName()
    {
        return $this->translate("Siteskin Async  Ad Tag");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    function getNameEN()
    {
        return 'Siteskin Async Ad Tag';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    function isAllowed($extra = null)
    {
        $isAllowed = parent::isAllowed($extra);
        return true;
    }

    function getOrder()
    {
        parent::getOrder();
        return 16;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
     function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
            if (in_array('comments', $this->defaultOptions)) {
                unset($this->defaultOptions['comments']);
            }
        }
        $options = array (
            'spacer'      => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'what'          => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'block'         => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'blockcampaign' => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'target'        => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'source'        => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            // 'siteskintype'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
             //~ 'contentWidth'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
             //~ 'leftOffset'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
             //~ 'topOffset'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
             //~ 'rightOffset'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
             //~ 'zIndex'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
             //~ 'fixed'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
             //~ 'hide'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
             //~ 'random'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD
        );

        return $options;
    }

    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
     function generateInvocationCode()
    {
      $aComments = array(
            'SSL Backup Comment' => "",
            'SSL Delivery Comment' => "",
            'Comment'              => "",
        );
        parent::prepareCommonInvocationData($aComments);

        $conf = $GLOBALS['_MAX']['CONF'];
        $mi = &$this->maxInvocation;
        //print_r($mi);

        $buffer = $mi->buffer;

        if (isset($mi->block) && $mi->block == '1') {
            $mi->parameters['block'] = "block=1";
        }
        if (isset($mi->blockcampaign) && $mi->blockcampaign == '1') {
            $mi->parameters['blockcampaign'] = "blockcampaign=1";
        }
       
		      $mi->parameters['contentWidth'] = "contentWidth=".'1155px';
        
		      $mi->parameters['leftOffset'] = "leftpadding=".'315px';
        
		      $mi->parameters['topOffset'] = "topOffset=".'0px';
		  
		      $mi->parameters['bg_link_target'] = "bg_link_target={BG_LINK_TARGET_ID}";
        
		      $mi->parameters['rightOffset'] = "rightpadding=".'0px';
        
		      $mi->parameters['zIndex'] = "zIndex=".'1';
        
		      $mi->parameters['fixed'] = "fixed=".'1';
        
		      $mi->parameters['hide'] = "hide=".'none';
        
		      $mi->parameters['random'] = "random=".'0';
        

        // Add ID
        $mi->parameters['id'] = 'id='.md5("{$conf['webpath']['delivery']}*{$conf['webpath']['deliverySSL']}").'112';
        $mi->parameters = array_map(function ($v) use ($conf) {
            return preg_replace('#^(.*)=(.*)$#', 'data-'.$conf['var']['product'].'-$1="$2"', $v);
        }, $mi->parameters);
        $buffer .= '<ins '.join(' ', $mi->parameters).'></ins>'.PHP_EOL;
        $buffer .= '<script async src="'.'//'.$conf['webpath']['admin'].'/plugins/Siteskin/siteskinasyncjs.php'.'"></script>';
        return $buffer;
    }


    function setInvocation(&$invocation) {
        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;
    }

}

?>
