<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage InvocationTags
 * @author     Radek Maciaszek <radek@m3.net>
 *
 */

require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_siteskin extends Plugins_InvocationTags
{

    /**
     * Return name of plugin
     *
     * @return string
     */
    function getName()
    {
        return $this->translate("Siteskin Ad Tag");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    function getNameEN()
    {
        return 'Siteskin Ad Tag';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    function isAllowed($extra = null)
    {
        $isAllowed = parent::isAllowed($extra);
        return true;
    }

    function getOrder()
    {
        parent::getOrder();
        return 15;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
    function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
        $options = array (
            'spacer'      => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'what'          => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //'clientid'      => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'campaignid'    => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'block'         => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'target'        => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'source'        => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'withtext'      => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'blockcampaign' => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            'charset'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
			 //'siteskintype'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD
        );

        return $options;
    }

    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    function generateInvocationCode()
    {
        $aComments = array(
            'SSL Delivery Comment' => '',
            'Comment'              => $this->translate("
  * This noscript section of this tag only shows image banners. There
  * is no width or height in these banners, so if you want these tags to
  * allocate space for the ad before it shows, you will need to add this
  * information to the <img> tag.
  *
  * If you do not want to deal with the intricities of the noscript
  * section, delete the tag (from <noscript>... to </noscript>). On
  * average, the noscript tag is called from less than 1% of internet
  * users."),
            );
        parent::prepareCommonInvocationData($aComments);

        $conf = $GLOBALS['_MAX']['CONF'];
        $mi = &$this->maxInvocation;

        $buffer = $mi->buffer;
		//print_r($mi->buffer);
       if (isset($mi->withtext) && $mi->withtext != '0') {
            $mi->parameters['withtext'] = "withtext=1";
        }
        if (isset($mi->block) && $mi->block == '1') {
            $mi->parameters['block'] = "block=1";
        }
	/* openXmods - DAC024  */
	
	
	if (isset($mi->siteskintype) && $mi->siteskintype != '0') {
		      $mi->parameters['siteskintype'] = "direction=".$mi->siteskintype;
        }
	        
	/* openXmods - DAC024  */
        if (isset($mi->blockcampaign) && $mi->blockcampaign == '1') {
            $mi->parameters['blockcampaign'] = "blockcampaign=1";
        }
        if (!empty($mi->campaignid)) {
            $mi->parameters['campaignid'] = "campaignid=".$mi->campaignid;
        }
        // The cachebuster for JS tags is auto-generated
        unset($mi->parameters['cb']);

        $filearr = explode('/',MAX_commonConstructPartialDeliveryUrl($conf['file']['js'], true));

		$filearr[sizeof($filearr)-1] = 'siteskin.php';
        

			$endfile='//'.$conf['webpath']['admin'].'/plugins/Siteskin/siteskin.php';
			 
        $m3_u = "https:".$endfile."";


        if (count($mi->parameters) > 0) {
            $m3_u .= "?".implode ("&amp;", $mi->parameters)."";
        }


/* openXmods - DAC024  */

 $buffer .= "<script type='text/javascript'>";
 
 $buffer .= " 
var siteskinad = {
    'contentWidth' : '1155px', // size of the regular content in pixel or Distance between the Left and Right Ad in pixel
    'leftOffset'   : '315px',   // left ad position adjustment -/+ pixel left/right
    'classname'   : '',
    'topOffset'    : '0px',   // top position of the ads
    'bg_link_target' : '{BG_LINK_TARGET_ID}',
    'rightOffset'  : '0px',   // right ad adjustment
    'zIndex'       : '1',     // css style z-index for the ads
    'fixed'        : '1',     // 0=>ads scroll with content, 1=>ads stay fixed
    'hide'         : 'none',  // hide a banner: one of 'none', 'left', 'right'
    'random'       :  Math.floor(Math.random() * 99999999999)
 };";
 $buffer .= "\n";
 $acr='\x3cscript type="text/javascript" ';
 
 $end='\x3e\x3c/script\x3e';
 $path=$m3_u;
  
$buffer .= "document.write('".$acr;
$buffer .= "src=\"".$path."&amp;leftpadding='";
$buffer .= "+siteskinad.leftOffset+'&amp;contentWidth='+siteskinad.contentWidth+'&amp;topoffset='+siteskinad.topOffset+'&amp;rightpadding='+siteskinad.rightOffset+'&amp;zindex='+siteskinad.zIndex+'&amp;bg_link_target='+siteskinad.bg_link_target+'&amp;fixed='+siteskinad.fixed+'&amp;hide='+siteskinad.hide+'&amp;classname='+siteskinad.classname+'";
$buffer .=	 "\"";
$buffer .= $end;
$buffer .= "');";
$buffer .= "</script>\n";

      

/* openXmods - DAC024  */

        return $buffer;
    }

    function setInvocation(&$invocation) {
        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;
    }

}

?>
